/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.FolderWatcher;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderSyncController
extends FolderWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FolderSyncController.class);
    private final Set<FolderListener> listener = new HashSet<FolderListener>();
    private final Connection connection;
    private boolean subscribed = false;

    public FolderSyncController(Connection connection, Location location) {
        super(location);
        this.connection = connection;
        this.connection.setFolderListener(location, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FolderListener listener) {
        FolderSyncController folderSyncController = this;
        synchronized (folderSyncController) {
            if (this.listener.add(listener)) {
                this.sync();
            }
        }
        this.transmitCache(listener);
    }

    public synchronized void removeListener(FolderListener listener) {
        if (this.listener.remove(listener)) {
            this.sync();
        }
    }

    public synchronized void sync() {
        this.sync(false);
    }

    public synchronized void resync() {
        this.sync(true);
    }

    private synchronized void sync(boolean force) {
        boolean needSubscription;
        boolean bl = needSubscription = !this.listener.isEmpty();
        if (needSubscription != this.subscribed || force) {
            if (needSubscription) {
                this.subscribe();
            } else {
                this.unsubscribe();
            }
        }
    }

    private synchronized void subscribe() {
        logger.debug("subscribing to folder: {}", (Object)this.location);
        this.subscribed = true;
        try {
            this.connection.subscribeFolder(this.location);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private synchronized void unsubscribe() {
        logger.debug("unsubscribing from folder: {}", (Object)this.location);
        this.subscribed = false;
        try {
            this.connection.unsubscribeFolder(this.location);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected void handleError(Throwable e) {
        this.subscribed = false;
    }

    private void transmitCache(FolderListener listener) {
        listener.folderChanged(Collections.unmodifiableList(new ArrayList(this.cache.values())), Collections.<String>emptySet(), true);
    }

    @Override
    public void folderChanged(Collection<Entry> added, Collection<String> removed, boolean full) {
        super.folderChanged(added, removed, full);
        for (FolderListener listener : this.listener) {
            listener.folderChanged(added, removed, full);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        FolderSyncController folderSyncController = this;
        synchronized (folderSyncController) {
            this.subscribed = false;
            this.cache.clear();
        }
        for (FolderListener listener : this.listener) {
            listener.folderChanged(Collections.<Entry>emptyList(), Collections.<String>emptySet(), true);
        }
    }
}

