/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter;

public enum Assertion {
    EQUALITY(0),
    PRESENCE(1),
    SUBSTRING(2),
    GREATEREQ(3),
    LESSEQ(4),
    APPROXIMATE(6),
    LESSTHAN(7),
    GREATERTHAN(8);

    private final int op;

    private Assertion(int operator) {
        this.op = operator;
    }

    public static Assertion fromValue(int op) {
        switch (op) {
            case 0: {
                return EQUALITY;
            }
            case 1: {
                return PRESENCE;
            }
            case 2: {
                return SUBSTRING;
            }
            case 3: {
                return GREATEREQ;
            }
            case 4: {
                return LESSEQ;
            }
            case 6: {
                return APPROXIMATE;
            }
            case 7: {
                return LESSTHAN;
            }
            case 8: {
                return GREATERTHAN;
            }
        }
        return null;
    }

    public static Assertion fromString(String op) {
        if ("=".equals(op)) {
            return EQUALITY;
        }
        if ("=*".equals(op)) {
            return PRESENCE;
        }
        if (">=".equals(op)) {
            return GREATEREQ;
        }
        if (">".equals(op)) {
            return GREATERTHAN;
        }
        if ("<=".equals(op)) {
            return LESSEQ;
        }
        if ("<".equals(op)) {
            return LESSTHAN;
        }
        if ("~=".equals(op)) {
            return APPROXIMATE;
        }
        return null;
    }

    public String toString() {
        switch (this.op) {
            case 0: {
                return "=";
            }
            case 1: {
                return "=*";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<=";
            }
            case 6: {
                return "~=";
            }
            case 7: {
                return "<";
            }
            case 8: {
                return ">";
            }
        }
        return null;
    }

    public int toValue() {
        return this.op;
    }
}

