/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter;

import java.util.Collection;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.internal.Encoder;

public class FilterAssertion
implements Filter {
    private String attribute;
    private Assertion assertion;
    private Object value;

    public FilterAssertion(String attribute, Assertion assertion, Object value) {
        this.attribute = attribute;
        this.assertion = assertion;
        this.value = value;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(Assertion assertion) {
        this.assertion = assertion;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return "(" + this.attribute + this.assertion.toString() + this.nullSafeToString(this.value) + ")";
    }

    @Override
    public boolean isAssertion() {
        return true;
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.assertion == null;
    }

    private String nullSafeToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            Object[] valueList = ((Collection)value).toArray();
            return this.stringFromArray(valueList);
        }
        if (value instanceof String[]) {
            Object[] valueList = (String[])value;
            return this.stringFromArray(valueList);
        }
        return Encoder.encode(value.toString());
    }

    private String stringFromArray(Object[] valueList) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Object[] objectArray = valueList;
        int n = valueList.length;
        int n2 = 0;
        while (n2 < n) {
            Object part = objectArray[n2];
            if (i > 0 && i < valueList.length) {
                sb.append("*");
            }
            sb.append(part == null ? "" : Encoder.encode(part.toString()));
            ++i;
            ++n2;
        }
        return sb.toString();
    }
}

