/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.Operator;

public class FilterExpression
implements Filter {
    private Operator operator;
    private final List<Filter> filterSet = new ArrayList<Filter>();

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.operator == null) {
            for (Filter filter : this.filterSet) {
                result.append(filter.toString());
            }
        } else {
            result.append("(");
            result.append(this.operator.toString());
            for (Filter filter : this.filterSet) {
                result.append(filter.toString());
            }
            result.append(")");
        }
        return result.toString();
    }

    public List<Filter> getFilterSet() {
        return this.filterSet;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean isAssertion() {
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.operator == null;
    }

    public static FilterExpression negate(Filter expression) {
        FilterExpression negation = new FilterExpression();
        negation.setOperator(Operator.NOT);
        negation.getFilterSet().add(expression);
        return negation;
    }
}

