/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter.bean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.bean.Messages;
import org.eclipse.scada.utils.propertyeditors.PropertyEditorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMatcher {
    private static final PropertyEditorRegistry defaultRegistry = new PropertyEditorRegistry(true);
    private static final Logger logger = LoggerFactory.getLogger(BeanMatcher.class);

    public static boolean matches(Filter filter, Object object, boolean ifEmpty, PropertyEditorRegistry registry) {
        if (filter == null) {
            return ifEmpty;
        }
        try {
            if (filter.isEmpty()) {
                return ifEmpty;
            }
            if (filter.isAssertion()) {
                return BeanMatcher.matchAssertion((FilterAssertion)filter, object, ifEmpty, registry);
            }
            if (filter.isExpression()) {
                return BeanMatcher.matchExpression((FilterExpression)filter, object, ifEmpty, registry);
            }
            logger.warn("Filter no none of: empty, assertion or expression");
            return ifEmpty;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("BeanMatcher.Error.FailedToFilter"), e);
        }
    }

    public static Collection<Object> filter(Filter filter, Collection<Object> list, boolean ifEmpty, PropertyEditorRegistry registry) {
        ArrayList<Object> result = new ArrayList<Object>();
        BeanMatcher.filter(filter, list, result, ifEmpty, registry);
        return result;
    }

    public static void filter(Filter filter, Collection<Object> list, Collection<Object> targetCollection, boolean ifEmpty, PropertyEditorRegistry registry) {
        for (Object object : list) {
            if (!BeanMatcher.matches(filter, object, ifEmpty, registry)) continue;
            targetCollection.add(object);
        }
    }

    private static boolean matchExpression(FilterExpression filterExpression, Object object, boolean ifEmpty, PropertyEditorRegistry registry) throws Exception {
        switch (filterExpression.getOperator()) {
            case AND: {
                for (Filter filter : filterExpression.getFilterSet()) {
                    if (BeanMatcher.matches(filter, object, ifEmpty, registry)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Filter filter : filterExpression.getFilterSet()) {
                    if (!BeanMatcher.matches(filter, object, ifEmpty, registry)) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                if (filterExpression.getFilterSet().isEmpty()) break;
                return !BeanMatcher.matches(filterExpression.getFilterSet().get(0), object, ifEmpty, registry);
            }
        }
        return ifEmpty;
    }

    private static boolean matchAssertion(FilterAssertion filterAssertion, Object object, boolean ifEmpty, PropertyEditorRegistry registry) throws Exception {
        PropertyDescriptor pd = BeanMatcher.getProperyDescriptor(object.getClass(), filterAssertion.getAttribute());
        if (pd == null) {
            return false;
        }
        Method m = pd.getReadMethod();
        if (m == null) {
            return false;
        }
        switch (filterAssertion.getAssertion()) {
            case EQUALITY: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                int i = BeanMatcher.compare(value, (String)filterAssertion.getValue(), registry);
                return i == 0;
            }
            case GREATERTHAN: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                int i = BeanMatcher.compare(value, (String)filterAssertion.getValue(), registry);
                return i > 0;
            }
            case LESSTHAN: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                int i = BeanMatcher.compare(value, (String)filterAssertion.getValue(), registry);
                return i < 0;
            }
            case GREATEREQ: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                int i = BeanMatcher.compare(value, (String)filterAssertion.getValue(), registry);
                return i >= 0;
            }
            case LESSEQ: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                int i = BeanMatcher.compare(value, (String)filterAssertion.getValue(), registry);
                return i <= 0;
            }
            case SUBSTRING: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                return BeanMatcher.matchSubString(value.toString(), (Collection)filterAssertion.getValue());
            }
            case PRESENCE: {
                Object value = BeanMatcher.getValue(m, object);
                return value != null;
            }
            case APPROXIMATE: {
                Object value = BeanMatcher.getValue(m, object);
                if (value == null) {
                    return false;
                }
                return BeanMatcher.matchRegexString(value.toString(), (String)filterAssertion.getValue());
            }
        }
        return false;
    }

    private static boolean matchRegexString(String string, String value) {
        Pattern p = Pattern.compile(value);
        Matcher m = p.matcher(string);
        return m.find();
    }

    private static int compare(Object value, String stringValue, PropertyEditorRegistry registry) {
        Object cvtValue = BeanMatcher.convert(stringValue, value.getClass(), registry);
        if (value instanceof Comparable) {
            return ((Comparable)value).compareTo(cvtValue);
        }
        return value.toString().compareTo(cvtValue.toString());
    }

    private static Object convert(String stringValue, Class<? extends Object> clazz, PropertyEditorRegistry registry) {
        if (clazz == String.class) {
            return stringValue;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Enum.valueOf(clazz, stringValue);
        }
        PropertyEditor editor = null;
        editor = registry != null ? registry.findCustomEditor(clazz) : defaultRegistry.findCustomEditor(clazz);
        if (editor == null) {
            try {
                Class<?> propertyEditorClass = Class.forName(String.valueOf(clazz.getName()) + "Editor");
                if (propertyEditorClass != null) {
                    editor = (PropertyEditor)propertyEditorClass.newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(Messages.getString("BeanMatcher.Error.FailedToConvert"), stringValue, clazz), e);
            }
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format(Messages.getString("BeanMatcher.Error.UnableToConvert"), stringValue, clazz));
        }
        editor.setAsText(stringValue);
        return editor.getValue();
    }

    private static boolean matchSubString(String string, Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        for (String token : collection) {
            if (token.length() == 0) {
                sb.append(".*");
                continue;
            }
            sb.append(Pattern.quote(token));
        }
        sb.append("$");
        return BeanMatcher.matchRegexString(string, sb.toString());
    }

    protected static Object getValue(Method readMethod, Object object) throws Exception {
        return readMethod.invoke(object, new Object[0]);
    }

    protected static PropertyDescriptor getProperyDescriptor(Class<?> clazz, String name) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(name)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }
}

