/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter.internal;

import org.eclipse.scada.utils.filter.internal.Tokenizer;

public class Encoder {
    public static final byte CHAR_NUL = 0;
    public static final byte CHAR_ASTERISK = 42;
    public static final byte CHAR_PAREN_LEFT = 40;
    public static final byte CHAR_PAREN_RIGHT = 41;
    public static final byte CHAR_BACKSPACE = 92;

    public static String encode(String toEncode) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < toEncode.length()) {
            char b = toEncode.charAt(i);
            switch (b) {
                case '\u0000': 
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    sb.append("\\" + String.format("%02x", b & 0xFF));
                    break;
                }
                default: {
                    if (b < ' ' || b > '\u007f') {
                        sb.append("\\" + String.format("%02x", b & 0xFF));
                        break;
                    }
                    sb.append(Character.valueOf(b));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decode(String toDecode) throws Tokenizer.TokenizeException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < toDecode.length()) {
            char c = toDecode.charAt(i);
            if (c == '\\') {
                if (i + 2 >= toDecode.length()) {
                    throw new Tokenizer.TokenizeException("valid escape sequence expected");
                }
                String ec = "" + toDecode.charAt(i + 1) + toDecode.charAt(i + 2);
                try {
                    sb.append(String.valueOf((char)Integer.parseInt(ec, 16)));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Tokenizer.TokenizeException("valid escape sequence expected");
                }
                i += 2;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

