/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.filter.internal;

import java.util.Iterator;
import org.eclipse.scada.utils.filter.internal.Messages;
import org.eclipse.scada.utils.filter.internal.Tokens;

public class Tokenizer
implements Iterable<Tokens.Token>,
Iterator<Tokens.Token> {
    private final char[] filter;
    private int pos = 0;
    private boolean isAttribute = false;
    private boolean isValue = false;
    private boolean isAssertion = false;
    private StringBuilder buffer;

    public Tokenizer(String toParse) {
        this.filter = toParse.toCharArray();
    }

    @Override
    public Iterator<Tokens.Token> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.filter != null && this.pos < this.filter.length;
    }

    @Override
    public Tokens.Token next() {
        int overflow = 0;
        while (true) {
            if (this.pos >= this.filter.length || ++overflow > this.filter.length) {
                throw new TokenizeException(String.format(Messages.getString("Tokenizer.Error.InvalidSyntax"), this.pos));
            }
            String currentChar = String.valueOf(this.filter[this.pos]);
            if (currentChar.equals(Tokens.tokenLeftParen.getValue())) {
                ++this.pos;
                this.buffer = new StringBuilder();
                return Tokens.tokenLeftParen;
            }
            if (currentChar.equals(Tokens.tokenRightParen.getValue())) {
                if (this.isValue) {
                    this.isValue = false;
                    return new Tokens.TokenValue(this.buffer.toString());
                }
                ++this.pos;
                return Tokens.tokenRightParen;
            }
            if (Tokens.TokenOperator.isOperator(currentChar)) {
                ++this.pos;
                return Tokens.TokenOperator.getByValue(currentChar);
            }
            if (!(this.isAttribute || this.isAssertion || this.isValue)) {
                this.isAttribute = true;
                continue;
            }
            if (this.isAttribute && !this.isAssertion && !this.isValue) {
                if (this.pos + 1 >= this.filter.length) {
                    throw new TokenizeException(String.format(Messages.getString("Tokenizer.Error.InvalidSyntax"), this.pos));
                }
                String lookahead = String.valueOf(currentChar) + this.filter[this.pos + 1] + (this.filter.length > this.pos + 2 ? Character.valueOf(this.filter[this.pos + 2]) : "");
                if (Tokens.TokenAssertion.isAssertion(lookahead)) {
                    this.isAssertion = true;
                    this.isAttribute = false;
                    Tokens.TokenAttribute token = new Tokens.TokenAttribute(this.buffer.toString());
                    this.buffer = new StringBuilder();
                    return token;
                }
                if (this.buffer == null) {
                    throw new TokenizeException(String.format(Messages.getString("Tokenizer.Error.InvalidSyntax"), this.pos));
                }
                this.buffer.append(currentChar);
                ++this.pos;
                continue;
            }
            if (this.isAssertion) {
                this.isAttribute = false;
                this.isAssertion = false;
                this.isValue = true;
                String lookahead2 = String.valueOf(currentChar) + this.filter[this.pos + 1];
                String lookahead3 = String.valueOf(currentChar) + this.filter[this.pos + 1] + (this.filter.length > this.pos + 2 ? Character.valueOf(this.filter[this.pos + 2]) : "");
                if ("=*)".equals(lookahead3)) {
                    this.pos += 2;
                    return Tokens.TokenAssertion.getByValue("=*");
                }
                if ("=*".equals(lookahead2)) {
                    ++this.pos;
                    return Tokens.TokenAssertion.getByValue("=");
                }
                if (Tokens.TokenAssertion.getByValue(lookahead2) != null) {
                    this.pos += 2;
                    return Tokens.TokenAssertion.getByValue(lookahead2);
                }
                ++this.pos;
                return Tokens.TokenAssertion.getByValue(currentChar);
            }
            if (this.isAttribute || this.isAssertion || !this.isValue) break;
            this.buffer.append(currentChar);
            ++this.pos;
        }
        throw new TokenizeException(String.format(Messages.getString("Tokenizer.Error.InvalidSyntax"), this.pos));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class TokenizeException
    extends RuntimeException {
        private static final long serialVersionUID = 2256865968011732768L;

        public TokenizeException() {
        }

        public TokenizeException(String message, Throwable cause) {
            super(message, cause);
        }

        public TokenizeException(String message) {
            super(message);
        }

        public TokenizeException(Throwable cause) {
            super(cause);
        }
    }
}

