/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.utils.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowViewHandler
extends AbstractHandler {
    private static final String PARAMETER_NAME_VIEW_ID = "org.eclipse.scada.ui.utils.showView.viewId";

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        String value = event.getParameter(PARAMETER_NAME_VIEW_ID);
        try {
            String[] viewIds = value.split(":");
            if (viewIds.length == 1) {
                this.openView(viewIds[0], null, window);
            } else if (viewIds.length == 2) {
                this.openView(viewIds[0], viewIds[1], window);
            }
        }
        catch (PartInitException e) {
            throw new ExecutionException("Part could not be initialized", (Throwable)e);
        }
        return null;
    }

    private final void openView(String viewId, String secondaryId, IWorkbenchWindow activeWorkbenchWindow) throws PartInitException {
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        if (secondaryId != null) {
            activePage.showView(viewId, secondaryId, 1);
        } else {
            activePage.showView(viewId);
        }
    }
}

