/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtilsBean2;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;

public class VariantBeanHelper {
    private static final ConvertUtilsBean2 converter = new ConvertUtilsBean2();

    static {
        AbstractConverter cvt = new AbstractConverter(){

            protected Object convertToType(Class type, Object value) throws Throwable {
                if (value == null) {
                    return null;
                }
                if (value instanceof Boolean) {
                    return value;
                }
                if (value instanceof Number) {
                    if (((Number)value).intValue() != 0) {
                        return true;
                    }
                    return false;
                }
                return Boolean.parseBoolean(value.toString());
            }

            protected Class getDefaultType() {
                return Boolean.class;
            }
        };
        converter.register((Converter)cvt, Boolean.TYPE);
        converter.register((Converter)cvt, Boolean.class);
    }

    public static Map<String, Variant> extract(Object source) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Variant> result = new HashMap<String, Variant>();
        BeanInfo bi = Introspector.getBeanInfo(source.getClass());
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method m = pd.getReadMethod();
            if (m != null) {
                result.put(pd.getName(), Variant.valueOf((Object)m.invoke(source, new Object[0])));
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, Variant> extractSafe(Object source) {
        BeanInfo bi;
        HashMap<String, Variant> result = new HashMap<String, Variant>();
        try {
            bi = Introspector.getBeanInfo(source.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return result;
        }
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method m = pd.getReadMethod();
            if (m != null) {
                try {
                    result.put(pd.getName(), Variant.valueOf((Object)m.invoke(source, new Object[0])));
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return result;
    }

    public static void apply(Map<String, Variant> data, Object target, WriteAttributeResults results) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(target.getClass());
        for (Map.Entry<String, Variant> entry : data.entrySet()) {
            PropertyDescriptor pd = VariantBeanHelper.findDescriptor(bi, entry.getKey());
            if (pd != null) {
                try {
                    VariantBeanHelper.applyValue(target, pd, entry.getValue());
                    results.put(entry.getKey(), WriteAttributeResult.OK);
                }
                catch (Exception e) {
                    results.put(entry.getKey(), new WriteAttributeResult(e));
                }
                continue;
            }
            results.put(entry.getKey(), new WriteAttributeResult(new IllegalArgumentException(String.format("'%s' is not a property name of '%s'", entry.getKey(), target.getClass().getName()))));
        }
    }

    public static void applyValue(Object target, PropertyDescriptor pd, Variant value) throws OperationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = pd.getWriteMethod();
        if (m == null) {
            throw new OperationException(String.format("Property '%s' is write protected", pd.getName()));
        }
        Class<Variant> targetType = pd.getPropertyType();
        if (targetType.isAssignableFrom(Variant.class)) {
            m.invoke(target, value);
            return;
        }
        if (!VariantBeanHelper.applyValueAsObject(target, pd, value.getValue())) {
            throw new OperationException(String.format("There is no way to convert '%s' to '%s'", value, targetType));
        }
    }

    private static boolean applyValueAsObject(Object target, PropertyDescriptor pd, Object value) throws IllegalAccessException, InvocationTargetException, OperationException {
        if (value == null) {
            pd.getWriteMethod().invoke(target, new Object[1]);
            return true;
        }
        Object targetType = converter.convert(value, pd.getPropertyType());
        if (targetType == null) {
            throw new OperationException(String.format("Unable to convert '%s' to '%s'", value.getClass(), pd.getPropertyType()));
        }
        pd.getWriteMethod().invoke(target, targetType);
        return true;
    }

    private static PropertyDescriptor findDescriptor(BeanInfo bi, String propertyName) {
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(propertyName)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }
}

