/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.controller.tools;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.controller.MouseDragZoomer;
import org.eclipse.scada.chart.swt.controller.MouseTransformer;
import org.eclipse.scada.chart.swt.controller.MouseWheelZoomer;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.MouseController;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractObserver;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;
import org.eclipse.scada.ui.chart.viewer.controller.ChartController;
import org.eclipse.scada.ui.chart.viewer.controller.ControllerManager;

public class MouseControllerImpl
extends AbstractObserver
implements ChartController {
    private final ChartContext chartContext;
    private MouseTransformer mouseTransformer;
    private MouseDragZoomer mouseDragZoomer;
    private MouseWheelZoomer mouseWheelZoomer;
    private XAxisViewer selectedXAxis;
    private YAxisViewer selectedYAxis;
    private org.eclipse.scada.ui.chart.model.YAxis selectedYAxisElement;
    private XAxis selectedXAxisElement;

    public MouseControllerImpl(ControllerManager controllerManager, ChartContext chartContext, MouseController controller) {
        this.chartContext = chartContext;
        Chart chart = chartContext.getChart();
        DataBindingContext ctx = controllerManager.getContext();
        ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"selectedXAxis"), EMFObservables.observeValue((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__SELECTED_XAXIS));
        ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"selectedYAxis"), EMFObservables.observeValue((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__SELECTED_YAXIS));
    }

    protected void activate(org.eclipse.scada.chart.XAxis x, YAxis y) {
        this.mouseTransformer = new MouseTransformer(this.chartContext.getChartRenderer(), x, y);
        this.mouseDragZoomer = new MouseDragZoomer(this.chartContext.getChartRenderer(), x, y);
        this.mouseWheelZoomer = new MouseWheelZoomer(this.chartContext.getChartRenderer(), x, y);
    }

    protected void deactivate() {
        if (this.mouseTransformer != null) {
            this.mouseTransformer.dispose();
            this.mouseTransformer = null;
        }
        if (this.mouseDragZoomer != null) {
            this.mouseDragZoomer.dispose();
            this.mouseDragZoomer = null;
        }
        if (this.mouseWheelZoomer != null) {
            this.mouseWheelZoomer.dispose();
            this.mouseWheelZoomer = null;
        }
    }

    protected void updateState() {
        org.eclipse.scada.chart.XAxis x = this.getSelectedXAxisViewer();
        YAxis y = this.getSelectedYAxisViewer();
        if (this.mouseTransformer != null) {
            this.mouseTransformer.dispose();
            this.mouseTransformer = null;
        }
        if (this.mouseDragZoomer != null) {
            this.mouseDragZoomer.dispose();
            this.mouseDragZoomer = null;
        }
        if (this.mouseWheelZoomer != null) {
            this.mouseWheelZoomer.dispose();
            this.mouseWheelZoomer = null;
        }
        if (x != null && y != null) {
            this.activate(x, y);
        } else {
            this.deactivate();
        }
    }

    private YAxis getSelectedYAxisViewer() {
        return this.selectedYAxis != null ? this.selectedYAxis.getAxis() : null;
    }

    private org.eclipse.scada.chart.XAxis getSelectedXAxisViewer() {
        return this.selectedXAxis != null ? this.selectedXAxis.getAxis() : null;
    }

    public XAxis getSelectedXAxis() {
        return this.selectedXAxisElement;
    }

    public org.eclipse.scada.ui.chart.model.YAxis getSelectedYAxis() {
        return this.selectedYAxisElement;
    }

    public void setSelectedXAxis(XAxis axis) {
        XAxisViewer newSelection = this.chartContext.getxAxisLocator().findAxis(axis);
        if (this.selectedXAxis == newSelection) {
            return;
        }
        this.selectedXAxis = newSelection;
        this.selectedXAxisElement = axis;
        this.updateState();
    }

    public void setSelectedYAxis(org.eclipse.scada.ui.chart.model.YAxis axis) {
        YAxisViewer newSelection = this.chartContext.getyAxisLocator().findAxis(axis);
        if (this.selectedYAxis == newSelection) {
            return;
        }
        this.selectedYAxis = newSelection;
        this.selectedYAxisElement = axis;
        this.updateState();
    }

    @Override
    public void dispose() {
        this.deactivate();
        super.dispose();
    }
}

