/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.Date;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractInput
extends AbstractPropertyChange
implements ChartInput {
    private Date selectedTimestamp;
    private String selectedValue;
    private String selectedQuality;
    private ChartMouseMoveListener mouseMoveListener;
    private ChartRenderer chartRenderer;
    private boolean visible;
    private String label;
    private Object preview;

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("visible", this.visible, this.visible);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Date getSelectedTimestamp() {
        return this.selectedTimestamp;
    }

    protected void setSelectedTimestamp(Date selectedTimestamp) {
        this.selectedTimestamp = selectedTimestamp;
        this.firePropertyChange("selectedTimestamp", this.selectedTimestamp, this.selectedTimestamp);
    }

    @Override
    public void setSelection(Date date) {
        this.setSelectedTimestamp(date);
    }

    protected void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
        this.firePropertyChange("selectedValue", this.selectedValue, this.selectedValue);
    }

    @Override
    public String getSelectedValue() {
        return this.selectedValue;
    }

    protected void attachHover(ChartViewer viewer, final XAxis xAxis) {
        this.detachHover();
        this.chartRenderer = viewer.getChartRenderer();
        this.mouseMoveListener = new ChartMouseMoveListener(){

            public void onMouseMove(ChartMouseListener.MouseState state) {
                Rectangle chartRect = AbstractInput.this.chartRenderer.getClientAreaProxy().getClientRectangle();
                AbstractInput.this.handeMouseMove(state, xAxis.translateToValue(chartRect.width, (float)(state.x - chartRect.x)));
            }
        };
        this.chartRenderer.addMouseMoveListener(this.mouseMoveListener);
    }

    protected void detachHover() {
        if (this.mouseMoveListener != null && this.chartRenderer != null) {
            this.chartRenderer.removeMouseMoveListener(this.mouseMoveListener);
            this.mouseMoveListener = null;
            this.chartRenderer = null;
        }
    }

    protected void handeMouseMove(ChartMouseListener.MouseState e, long timestamp) {
        this.setSelectedTimestamp(new Date(timestamp));
    }

    @Override
    public void dispose() {
        this.detachHover();
    }

    @Override
    public String getSelectedQuality() {
        return this.selectedQuality;
    }

    protected void setSelectedQuality(String selectedQuality) {
        this.selectedQuality = selectedQuality;
        this.firePropertyChange("selectedQuality", this.selectedQuality, this.selectedQuality);
    }

    public void setLabel(String label) {
        this.label = label;
        this.firePropertyChange("label", this.label, this.label);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    private void setPreview(Object preview) {
        this.preview = preview;
        this.firePropertyChange("preview", this.preview, this.preview);
    }

    @Override
    public Object getPreview() {
        return this.preview;
    }

    protected void fireUpdatePreviews() {
        this.setPreview(new Object());
    }
}

