/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.sec.utils.password.HexCodec;
import org.eclipse.scada.sec.utils.password.PasswordDigestCodec;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.sec.utils.password.PasswordValidator;

public class DigestValidator
implements PasswordValidator {
    private final PasswordDigestCodec passwordDigestCodec;
    private final PasswordEncoding storedEncoding;
    private final List<PasswordEncoding> supportedInputEncodings;
    private final Charset passwordCharset;

    public DigestValidator(PasswordEncoding storedEncoding, String passwordCharsetEncoder, PasswordDigestCodec passwordDigestCodec) {
        this.storedEncoding = storedEncoding;
        this.passwordDigestCodec = passwordDigestCodec;
        this.supportedInputEncodings = Collections.unmodifiableList(Arrays.asList(storedEncoding, PasswordEncoding.PLAIN));
        this.passwordCharset = Charset.forName(passwordCharsetEncoder);
    }

    @Override
    public List<PasswordEncoding> getSupportedInputEncodings() {
        return this.supportedInputEncodings;
    }

    @Override
    public boolean validatePassword(Map<PasswordEncoding, String> passwords, String storedPassword) throws Exception {
        byte[] storedDigest = this.passwordDigestCodec.decode(storedPassword);
        String encodedPassword = passwords.get((Object)this.storedEncoding);
        if (encodedPassword != null) {
            byte[] providedDigest = new HexCodec().decode(encodedPassword);
            return MessageDigest.isEqual(providedDigest, storedDigest);
        }
        String plainPassword = passwords.get((Object)PasswordEncoding.PLAIN);
        if (plainPassword != null) {
            byte[] providedDigest = this.makeDigest(plainPassword);
            return MessageDigest.isEqual(providedDigest, storedDigest);
        }
        return false;
    }

    private byte[] makeDigest(String plainPassword) throws NoSuchAlgorithmException {
        MessageDigest digest = this.storedEncoding.getDigest();
        ByteBuffer data = this.passwordCharset.encode(plainPassword);
        digest.update(data.array(), 0, data.remaining());
        return digest.digest();
    }
}

