/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.scada.sec.utils.password.DigestEncoder;
import org.eclipse.scada.sec.utils.password.HexCodec;
import org.eclipse.scada.sec.utils.password.PasswordDigestCodec;
import org.eclipse.scada.sec.utils.password.PasswordEncoder;

public enum PasswordEncoding {
    PLAIN{
        private final PasswordEncoder encoder = new PasswordEncoder(){

            @Override
            public String encodePassword(String password) {
                return password;
            }
        };

        @Override
        public PasswordEncoder getEncoder(String characterEncoding, PasswordDigestCodec codec) throws Exception {
            return this.encoder;
        }

        @Override
        public MessageDigest getDigest() throws NoSuchAlgorithmException {
            return null;
        }
    }
    ,
    MD5{

        @Override
        public MessageDigest getDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("MD5");
        }

        @Override
        public PasswordEncoder getEncoder(String characterEncoding, PasswordDigestCodec codec) throws Exception {
            return new DigestEncoder("MD5", characterEncoding, codec);
        }
    }
    ,
    SHA1{

        @Override
        public PasswordEncoder getEncoder(String characterEncoding, PasswordDigestCodec codec) throws Exception {
            return new DigestEncoder("SHA1", characterEncoding, codec);
        }

        @Override
        public MessageDigest getDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("SHA1");
        }
    };


    private PasswordEncoding() {
    }

    public abstract PasswordEncoder getEncoder(String var1, PasswordDigestCodec var2) throws Exception;

    public String encodeToString(String password, String characterEncoding, PasswordDigestCodec codec) throws Exception {
        return this.getEncoder(characterEncoding, codec).encodePassword(password);
    }

    public String encodeToHexString(String password) throws Exception {
        return this.encodeToString(password, "UTF-8", new HexCodec());
    }

    public abstract MessageDigest getDigest() throws NoSuchAlgorithmException;

    /* synthetic */ PasswordEncoding(String string, int n, PasswordEncoding passwordEncoding) {
        this();
    }
}

