/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListData
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(ListData.class);
    private List<ListEntry> items = new CopyOnWriteArrayList<ListEntry>();
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public List<ListEntry> getItems() {
        return new ArrayList<ListEntry>(this.items);
    }

    public synchronized void setItems(List<ListEntry> items) {
        this.clear();
        this.items = items;
        this.fireAdded(this.items.toArray(new ListEntry[this.items.size()]));
        for (ListEntry entry : items) {
            entry.addObserver(this);
        }
    }

    public void add(ListEntry entry) {
        if (this.items.add(entry)) {
            this.fireAdded(new ListEntry[]{entry});
            entry.addObserver(this);
        }
    }

    public void add(Item item) {
        ListEntry entry = new ListEntry();
        entry.setDataItem(item);
        this.add(entry);
    }

    public void remove(ListEntry entry) {
        if (this.items.remove(entry)) {
            entry.deleteObserver(this);
            entry.clear();
            this.fireRemoved(new ListEntry[]{entry});
        }
    }

    public void removeAll(Collection<ListEntry> entries) {
        this.items.removeAll(entries);
        for (ListEntry entry : entries) {
            entry.deleteObserver(this);
            entry.clear();
        }
        this.fireRemoved(entries.toArray(new ListEntry[entries.size()]));
    }

    public synchronized void clear() {
        for (ListEntry entry : this.items) {
            entry.deleteObserver(this);
            entry.clear();
        }
        this.items.clear();
        this.fireRemoved(this.items.toArray(new ListEntry[this.items.size()]));
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        if (!this.items.isEmpty()) {
            listener.added(this.items.toArray(new ListEntry[this.items.size()]));
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(ListEntry[] entries) {
        logger.debug(String.format("Fire add for %d items", entries.length));
        for (Listener listener : this.listeners) {
            try {
                listener.added(entries);
            }
            catch (Exception e) {
                logger.warn("Failed while sending add notification", (Throwable)e);
            }
        }
    }

    protected void fireRemoved(ListEntry[] entries) {
        for (Listener listener : this.listeners) {
            try {
                listener.removed(entries);
            }
            catch (Exception e) {
                logger.warn("Failed while sending remove notification", (Throwable)e);
            }
        }
    }

    protected void fireUpdated(ListEntry[] entries) {
        logger.debug("Updating items: " + entries.length);
        for (Listener listener : this.listeners) {
            try {
                listener.updated(entries);
            }
            catch (Exception e) {
                logger.warn("Failed while sending update notification", (Throwable)e);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof ListEntry && this.items.contains(o)) {
            this.fireUpdated(new ListEntry[]{(ListEntry)o});
        }
    }
}

