/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.scada.da.ui.widgets.Activator;
import org.eclipse.scada.da.ui.widgets.realtime.ItemCellLabelProvider;
import org.eclipse.scada.da.ui.widgets.realtime.ItemDropAdapter;
import org.eclipse.scada.da.ui.widgets.realtime.ItemListContentProvider;
import org.eclipse.scada.da.ui.widgets.realtime.ListData;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntryComparator;
import org.eclipse.scada.da.ui.widgets.realtime.Messages;
import org.eclipse.scada.da.ui.widgets.realtime.RealtimeListAdapter;
import org.eclipse.scada.da.ui.widgets.realtime.RealtimeListDragSourceListener;
import org.eclipse.scada.da.ui.widgets.realtime.RemoveAction;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;

public class RealTimeListViewer
implements RealtimeListAdapter {
    private final RemoveAction removeAction;
    private TreeViewer viewer;
    private final ListData list = new ListData();
    private ItemListContentProvider contentProvider;
    private LinkedList<Integer> initialColWidth;

    public RealTimeListViewer() {
        this.removeAction = new RemoveAction(this);
    }

    public void createControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RealTimeListViewer.this.dispose();
            }
        });
        this.viewer = new TreeViewer(parent, 66306);
        TreeViewerColumn col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.RealTimeListViewer_Col_Text_Id);
        col.setLabelProvider((CellLabelProvider)new ItemCellLabelProvider());
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.RealTimeListViewer_Col_Text_State);
        col.setLabelProvider((CellLabelProvider)new ItemCellLabelProvider());
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.RealTimeListViewer_Col_Text_Type);
        col.setLabelProvider((CellLabelProvider)new ItemCellLabelProvider());
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.RealTimeListViewer_Col_Text_Value);
        col.setLabelProvider((CellLabelProvider)new ItemCellLabelProvider());
        this.viewer.getTree().setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.applyInitialColWidth(tableLayout);
        this.viewer.getTree().setLayout((Layout)tableLayout);
        this.contentProvider = new ItemListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setComparator((ViewerComparator)new ListEntryComparator());
        this.viewer.setInput((Object)this.list);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.removeAction);
        this.addDragSupport();
        this.addDropSupport();
    }

    protected void applyInitialColWidth(TableLayout tableLayout) {
        if (this.initialColWidth != null && !this.initialColWidth.isEmpty()) {
            for (Integer w : this.initialColWidth) {
                tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(w.intValue(), true));
            }
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.removeAction);
        this.list.clear();
        this.contentProvider.dispose();
    }

    @Override
    public void remove(ListEntry entry) {
        this.list.remove(entry);
    }

    @Override
    public void remove(Collection<ListEntry> entries) {
        this.list.removeAll(entries);
    }

    @Override
    public void add(ListEntry entry) {
        this.list.add(entry);
    }

    public void clear() {
        this.list.clear();
    }

    private void addDropSupport() {
        this.viewer.addDropSupport(7, new Transfer[]{ItemTransfer.getInstance(), TextTransfer.getInstance()}, (DropTargetListener)new ItemDropAdapter((Viewer)this.viewer, this));
    }

    private void addDragSupport() {
        this.viewer.addDragSupport(7, new Transfer[]{ItemTransfer.getInstance(), URLTransfer.getInstance(), TextTransfer.getInstance()}, (DragSourceListener)new RealtimeListDragSourceListener((Viewer)this.viewer));
    }

    public void setMenu(Menu menu) {
        this.viewer.getControl().setMenu(menu);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.removeDoubleClickListener(listener);
    }

    public void loadFrom(IMemento memento) {
        if (memento == null) {
            return;
        }
        try {
            this.initialColWidth = new LinkedList();
            IMemento tableMemento = memento.getChild("tableCols");
            if (tableMemento != null) {
                Integer w;
                int i = 0;
                while ((w = tableMemento.getInteger("col_" + i)) != null) {
                    this.initialColWidth.add(w);
                    ++i;
                }
            }
            IMemento[] iMementoArray = memento.getChildren("item");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                Item item = Item.loadFrom((IMemento)child);
                if (item != null) {
                    this.list.add(item);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.da.ui.widgets", Messages.RealTimeListViewer_ErrorLoadingData, (Throwable)e));
        }
    }

    public void saveTo(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento tableMemento = memento.createChild("tableCols");
        int i = 0;
        while (i < this.viewer.getTree().getColumnCount()) {
            TreeColumn col = this.viewer.getTree().getColumn(i);
            tableMemento.putInteger("col_" + i, col.getWidth());
            ++i;
        }
        for (ListEntry entry : this.list.getItems()) {
            Item item = entry.getItem();
            item.saveTo(memento.createChild("item"));
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void hookContextMenu(IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RealTimeListViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars(IViewSite viewSite) {
        IActionBars bars = viewSite.getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void contribueTo(IViewSite viewSite) {
        viewSite.setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(viewSite);
        this.contributeToActionBars(viewSite);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.removeAction);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.removeAction);
    }
}

