/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceFactory;
import org.eclipse.scada.vi.ui.user.viewer.ext.ExtensionDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scada.vi.ui.user";
    public static final String EXTP_VIEW = "org.eclipse.scada.vi.ui.user.view";
    public static final String EXTP_VIEWER = "org.eclipse.scada.vi.ui.user.viewer";
    private static final String ELE_VIEW_INSTANCE = "viewInstance";
    private static final String ELE_PROPERTY = "property";
    private static Activator plugin;
    private List<ViewInstanceDescriptor> descriptors;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static List<ExtensionDescriptor> getExtensionDescriptors() {
        LinkedList<ExtensionDescriptor> result = new LinkedList<ExtensionDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_VIEWER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("viewerExtension".equals(element.getName())) {
                result.add(new ExtensionDescriptor(element));
            }
            ++n2;
        }
        return result;
    }

    protected List<ViewInstanceDescriptor> internalGetDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = Activator.loadDescriptors();
        }
        return this.descriptors;
    }

    public static List<ViewInstanceDescriptor> getDescriptors() {
        return Activator.getDefault().internalGetDescriptors();
    }

    protected static List<ViewInstanceDescriptor> loadDescriptors() {
        LinkedList<ViewInstanceDescriptor> result = new LinkedList<ViewInstanceDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_VIEW);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewInstanceDescriptor descriptor;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELE_VIEW_INSTANCE.equals(element.getName()) && (descriptor = Activator.convert(element)) != null) {
                result.add(descriptor);
            }
            ++n2;
        }
        return result;
    }

    private static ViewInstanceDescriptor convert(IConfigurationElement element) {
        try {
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String parentId = element.getAttribute("parent");
            ViewInstanceFactory factory = (ViewInstanceFactory)element.createExecutableExtension("factoryClass");
            URI uri = Activator.makeUri(element.getContributor().getName(), element.getAttribute("resource"), element.getAttribute("uri"));
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(0);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(ELE_PROPERTY);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                properties.put(child.getAttribute("key"), child.getAttribute("value"));
                ++n2;
            }
            int order = 0;
            try {
                order = Integer.parseInt(element.getAttribute("order"));
            }
            catch (Exception exception) {}
            boolean defaultInstance = element.getAttribute("defaultInstance") == null ? false : Boolean.parseBoolean(element.getAttribute("defaultInstance"));
            boolean mainView = element.getAttribute("mainView") == null ? false : Boolean.parseBoolean(element.getAttribute("mainView"));
            Boolean zooming = element.getAttribute("zooming") == null ? null : Boolean.valueOf(Boolean.parseBoolean(element.getAttribute("zooming")));
            String summaryConnectionId = null;
            String summaryItemId = null;
            String summaryItem = element.getAttribute("summaryItem");
            if (summaryItem != null && summaryItem.contains("#")) {
                String[] tok = summaryItem.split("\\#", 2);
                summaryConnectionId = tok[0];
                summaryItemId = tok[1];
            }
            Expression lazyExpression = null;
            Expression visibleExpression = null;
            Expression defaultInstanceExpression = null;
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                IConfigurationElement[] childs = child.getChildren();
                if (childs != null && childs.length > 0) {
                    if ("laziness".equals(child.getName())) {
                        lazyExpression = ExpressionConverter.getDefault().perform(child.getChildren()[0]);
                    } else if ("visibility".equals(child.getName())) {
                        visibleExpression = ExpressionConverter.getDefault().perform(child.getChildren()[0]);
                    } else if ("defaultInstance".equals(child.getName())) {
                        defaultInstanceExpression = ExpressionConverter.getDefault().perform(child.getChildren()[0]);
                    }
                }
                ++n4;
            }
            return new ViewInstanceDescriptor(id, parentId, factory, uri, name, order, defaultInstance, zooming, lazyExpression, visibleExpression, defaultInstanceExpression, summaryConnectionId, summaryItemId, mainView, properties);
        }
        catch (Throwable e) {
            plugin.getLog().log(StatusHelper.convertStatus((String)PLUGIN_ID, (Throwable)e));
            return null;
        }
    }

    private static URI makeUri(String contributerId, String resource, String uri) throws URISyntaxException {
        if (uri != null && !uri.isEmpty()) {
            return new URI(uri);
        }
        Bundle bundle = Platform.getBundle((String)contributerId);
        return FileLocator.find((Bundle)bundle, (IPath)new Path(resource), new HashMap()).toURI();
    }

    public static ViewInstanceDescriptor findParent(ViewInstanceDescriptor descriptor) {
        return Activator.getDefault().findParentDescriptor(descriptor);
    }

    protected ViewInstanceDescriptor findParentDescriptor(ViewInstanceDescriptor childDescriptor) {
        if (childDescriptor.getParentId() == null || childDescriptor.getParentId().isEmpty()) {
            return null;
        }
        for (ViewInstanceDescriptor descriptor : this.descriptors) {
            if (descriptor.getId() == null || !descriptor.getId().equals(childDescriptor.getParentId())) continue;
            return descriptor;
        }
        return null;
    }
}

