/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ngp.common.codec.osbp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.protocol.ngp.common.mc.message.DataMessage;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageDecoder;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageEncoder;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryProtocol
implements MessageProtocol,
MessageEncoder,
MessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryProtocol.class);
    private final Map<Integer, BinaryMessageCodec> codeMap = new TreeMap<Integer, BinaryMessageCodec>();
    private final Map<Class<?>, BinaryMessageCodec> classMap = new HashMap();
    private final BinaryContext context;

    public BinaryProtocol(BinaryContext context, Collection<BinaryMessageCodec> codecs) {
        this.context = context;
        for (BinaryMessageCodec codec : codecs) {
            this.codeMap.put(codec.getMessageCode(), codec);
            this.classMap.put(codec.getMessageClass(), codec);
        }
    }

    public MessageEncoder getEncoder() {
        return this;
    }

    public MessageDecoder getDecoder() {
        return this;
    }

    public Object decodeMessage(DataMessage message) throws Exception {
        IoBuffer data = message.getData();
        int messageCode = data.getInt(0);
        logger.trace("Decoding message: {}", (Object)messageCode);
        BinaryMessageCodec codec = this.codeMap.get(messageCode);
        if (codec == null) {
            throw new IllegalStateException(String.format("Unable to decode unknown message code: 0x%08x", messageCode));
        }
        return codec.decodeMessage(this.context, data);
    }

    public DataMessage encodeMessage(Object message) throws Exception {
        if (message == null) {
            throw new NullPointerException("Unable to encode null messages");
        }
        BinaryMessageCodec codec = this.classMap.get(message.getClass());
        if (codec == null) {
            throw new IllegalArgumentException(String.format("Message class is unknown. Unable to encode: %s", message.getClass()));
        }
        return new DataMessage(codec.encodeMessage(this.context, message));
    }
}

