/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi;

import java.util.Map;
import java.util.Set;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class FilterUtil {
    protected static Filter createFilter(String operand, Map<String, String> parameters) throws InvalidSyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(operand);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            FilterUtil.addPair(sb, entry.getKey(), entry.getValue());
        }
        sb.append(")");
        return FrameworkUtil.createFilter((String)sb.toString());
    }

    public static Filter createClassFilter(String clazz) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format("(%s=%s)", "objectClass", clazz));
    }

    public static Filter createClassAndPidFilter(String clazz, String persistentId) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format("(&(%s=%s)(%s=%s))", "objectClass", clazz, "service.pid", persistentId));
    }

    public static Filter createClassAndPidFilter(Class<?> clazz, String persistentId) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format("(&(%s=%s)(%s=%s))", "objectClass", clazz.getName(), "service.pid", persistentId));
    }

    public static Filter createAndFilter(Filter ... filters) throws InvalidSyntaxException {
        return FilterUtil.createFilter("&", filters);
    }

    public static Filter createOrFilter(Filter ... filters) throws InvalidSyntaxException {
        return FilterUtil.createFilter("|", filters);
    }

    protected static Filter createFilter(String operand, Filter ... filters) throws InvalidSyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(operand);
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            sb.append(filter.toString());
            ++n2;
        }
        sb.append(")");
        return FrameworkUtil.createFilter((String)sb.toString());
    }

    public static Filter createAndFilter(Map<String, String> parameters) throws InvalidSyntaxException {
        return FilterUtil.createFilter("&", parameters);
    }

    public static Filter createOrFilter(Map<String, String> parameters) throws InvalidSyntaxException {
        return FilterUtil.createFilter("|", parameters);
    }

    public static Filter createAndFilter(String clazz, Map<String, String> parameters) throws InvalidSyntaxException {
        return FilterUtil.createAndFilter(FilterUtil.createClassFilter(clazz), FilterUtil.createAndFilter(parameters));
    }

    public static Filter createSimpleOr(String attribute, Set<String> values) throws InvalidSyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        for (String value : values) {
            FilterUtil.addPair(sb, attribute, value);
        }
        sb.append(")");
        return FrameworkUtil.createFilter((String)sb.toString());
    }

    private static void addPair(StringBuilder stringBuilder, String key, String value) {
        stringBuilder.append("(");
        stringBuilder.append(key);
        stringBuilder.append("=");
        stringBuilder.append(value);
        stringBuilder.append(")");
    }
}

