/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi;

import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleServiceTracker<T> {
    private static final Logger logger = LoggerFactory.getLogger(SingleServiceTracker.class);
    private final ServiceTracker<T, T> tracker;
    private final BundleContext context;
    private T currentService;
    private final SingleServiceListener<T> listener;
    private ServiceReference<T> currentRef;

    public SingleServiceTracker(BundleContext context, Filter filter, SingleServiceListener<T> listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerImplementation());
    }

    public SingleServiceTracker(BundleContext context, String clazz, SingleServiceListener<T> listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, clazz, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerImplementation());
    }

    public SingleServiceTracker(BundleContext context, Class<T> clazz, SingleServiceListener<T> listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, clazz, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerImplementation());
    }

    public synchronized void open() {
        this.tracker.open();
    }

    public synchronized void open(boolean trackAllServices) {
        this.tracker.open(trackAllServices);
    }

    public synchronized void close() {
        this.tracker.close();
        if (this.currentService != null) {
            logger.warn("Should be null by the tracker#close call");
            this.currentService = null;
            this.notifyService(null, null);
        }
    }

    protected synchronized T addingService(ServiceReference<T> reference) {
        logger.info("Adding service: {}", reference);
        Object service = this.context.getService(reference);
        if (this.currentService == null) {
            this.currentService = service;
            this.currentRef = reference;
            this.notifyService(this.currentRef, this.currentService);
        } else if (this.isHigher(reference, this.currentRef)) {
            this.currentRef = reference;
            this.currentService = service;
            this.notifyService(this.currentRef, this.currentService);
        }
        return (T)service;
    }

    private boolean isHigher(ServiceReference<T> reference, ServiceReference<T> currentRef) {
        int ref1 = 0;
        int ref2 = 0;
        try {
            ref1 = (Integer)reference.getProperty("service.ranking");
        }
        catch (Exception exception) {}
        try {
            ref2 = (Integer)currentRef.getProperty("service.ranking");
        }
        catch (Exception exception) {}
        return ref1 > ref2;
    }

    protected void modifiedService(ServiceReference<T> reference, Object service) {
    }

    protected synchronized void removedService(ServiceReference<T> reference, Object service) {
        this.context.ungetService(reference);
        if (this.currentService == service) {
            ServiceReference ref = this.tracker.getServiceReference();
            if (ref != null) {
                this.currentService = this.tracker.getService(ref);
                this.currentRef = ref;
                logger.info("Setting next service: {} / {}", new Object[]{ref, this.currentService});
                this.notifyService(this.currentRef, this.currentService);
            } else {
                logger.info("no more services left");
                this.currentService = null;
                this.currentRef = null;
                this.notifyService(null, null);
            }
        }
    }

    private void notifyService(ServiceReference<T> reference, T service) {
        if (this.listener != null) {
            try {
                this.listener.serviceChange(reference, service);
            }
            catch (Exception e) {
                logger.debug("Failed to notify service", (Throwable)e);
            }
        }
    }

    public T waitForService(long timeout) throws InterruptedException {
        return (T)this.tracker.waitForService(timeout);
    }

    public T getService() {
        return (T)this.tracker.getService();
    }

    private final class ServiceTrackerCustomizerImplementation
    implements ServiceTrackerCustomizer<T, T> {
        private ServiceTrackerCustomizerImplementation() {
        }

        public void removedService(ServiceReference<T> reference, T service) {
            SingleServiceTracker.this.removedService(reference, service);
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
            SingleServiceTracker.this.modifiedService(reference, service);
        }

        public T addingService(ServiceReference<T> reference) {
            return SingleServiceTracker.this.addingService(reference);
        }
    }
}

