/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding.observable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.scada.utils.str.StringHelper;

public class StringSplitListObservable
extends ObservableList {
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            StringSplitListObservable.this.fireStale();
        }
    };
    private IObservableValue value;
    private final String delimiter;
    private final String pattern;
    private IValueChangeListener changeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            StringSplitListObservable.this.handleValueChange(event.diff);
        }
    };
    private IDisposeListener disposeListener = new IDisposeListener(){

        public void handleDispose(DisposeEvent event) {
            StringSplitListObservable.this.dispose();
        }
    };

    protected StringSplitListObservable(IObservableValue value, String delimiter, String pattern, Object valueType) {
        super(value.getRealm(), new LinkedList(), valueType);
        this.value = value;
        this.pattern = pattern;
        this.delimiter = delimiter;
        value.addValueChangeListener(this.changeListener);
        value.addStaleListener(this.staleListener);
        value.addDisposeListener(this.disposeListener);
    }

    private List<String> makeList(Object value) {
        if (!(value instanceof String)) {
            return Collections.emptyList();
        }
        String string = (String)value;
        return Arrays.asList(string.split(this.pattern));
    }

    private void handleValueChange(ValueDiff diff) {
        this.updateWrappedList(this.makeList(diff.getNewValue()));
    }

    public boolean add(Object o) {
        this.checkRealm();
        boolean result = this.wrappedList.add(o);
        this.updateValue();
        return result;
    }

    public boolean addAll(Collection c) {
        this.checkRealm();
        boolean result = this.wrappedList.addAll(c);
        this.updateValue();
        return result;
    }

    public void clear() {
        this.checkRealm();
        this.wrappedList.clear();
        this.updateValue();
    }

    public Object remove(int index) {
        this.checkRealm();
        Object result = this.wrappedList.remove(index);
        this.updateValue();
        return result;
    }

    public boolean remove(Object o) {
        this.checkRealm();
        boolean result = this.wrappedList.remove(o);
        this.updateValue();
        return result;
    }

    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        Object result = super.move(oldIndex, newIndex);
        this.updateValue();
        return result;
    }

    public void add(int index, Object element) {
        this.checkRealm();
        this.wrappedList.add(index, element);
        this.updateValue();
    }

    public boolean addAll(int index, Collection c) {
        this.checkRealm();
        boolean result = this.wrappedList.addAll(index, c);
        this.updateValue();
        return result;
    }

    public boolean removeAll(Collection c) {
        this.checkRealm();
        boolean result = this.wrappedList.removeAll(c);
        this.updateValue();
        return result;
    }

    public boolean retainAll(Collection c) {
        this.checkRealm();
        boolean result = this.wrappedList.retainAll(c);
        this.updateValue();
        return result;
    }

    private void updateValue() {
        this.value.setValue((Object)StringHelper.join((Collection)this.wrappedList, (String)this.delimiter));
    }

    public boolean isStale() {
        ObservableTracker.getterCalled((IObservable)this);
        return this.value.isStale();
    }

    public synchronized void dispose() {
        if (this.value != null) {
            this.value.removeValueChangeListener(this.changeListener);
            this.value.removeStaleListener(this.staleListener);
            this.value.removeDisposeListener(this.disposeListener);
            this.value = null;
            this.changeListener = null;
            this.staleListener = null;
            this.disposeListener = null;
        }
        super.dispose();
    }

    public static IObservableList observeString(IObservableValue value, String delimiter, String pattern) {
        return new StringSplitListObservable(value, delimiter, pattern, null);
    }
}

