/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.text.ParseException;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.details.swt.widgets.Messages;
import org.eclipse.scada.vi.details.swt.widgets.ReadableComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteableComposite
extends ReadableComposite {
    private static final Logger logger = LoggerFactory.getLogger(WriteableComposite.class);
    private Double ceil;
    private Double floor;

    public WriteableComposite(Composite parent, int style, String format, String decimal, boolean isText, Double ceil, Double floor, String attribute, String hdConnectionId, String hdItemId) {
        super(parent, style, format, decimal, isText, attribute);
        this.ceil = ceil;
        this.floor = floor;
    }

    protected void addDefaultKeyListener(final Text text) {
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000050 || arg0.keyCode == 13) {
                    if (WriteableComposite.this.isValidInput(text.getText())) {
                        WriteableComposite.this.triggerCommand();
                    } else {
                        WriteableComposite.this.makeWarnDialog();
                    }
                }
            }
        });
    }

    protected abstract void triggerCommand();

    protected void makeWarnDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openInformation((Shell)shell, (String)Messages.WriteableComposite_wrongInput, (String)String.format(Messages.WriteableComposite_requiredInput, this.ceil, this.floor));
    }

    protected boolean isValidInput(String text) {
        if (this.isText) {
            return true;
        }
        boolean ret = false;
        if (this.ceil == null && this.floor == null) {
            return true;
        }
        if (this.ceil != null && this.floor == null) {
            this.floor = Double.MIN_VALUE;
        } else if (this.ceil == null && this.floor != null) {
            this.ceil = Double.MAX_VALUE;
        }
        try {
            Double d = this.parseDecimal(text);
            if (d >= this.floor && d <= this.ceil) {
                ret = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn(String.valueOf(Messages.WriteableComposite_invalidInput) + text);
        }
        catch (ParseException parseException) {
            logger.warn(String.valueOf(Messages.WriteableComposite_invalidInput) + text);
        }
        return ret;
    }

    protected void setCeil(DataItemValue value) {
        try {
            this.ceil = value.isAttribute("remote.level.ceil.preset") != null ? Double.valueOf(((Variant)value.getAttributes().get("remote.level.ceil.preset")).asDouble()) : Double.valueOf(((Variant)value.getAttributes().get("org.eclipse.scada.da.level.ceil.preset")).asDouble());
            logger.info("Ceil set successfully: {}", (Object)this.ceil);
        }
        catch (NullValueException nullValueException) {
            logger.info("Could not set ceil");
        }
        catch (NotConvertableException notConvertableException) {
            logger.info("Could not set ceil");
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Could not set ceil");
        }
    }

    protected void setFloor(DataItemValue value) {
        try {
            this.floor = value.isAttribute("remote.level.floor.preset") != null ? Double.valueOf(((Variant)value.getAttributes().get("remote.level.floor.preset")).asDouble()) : Double.valueOf(((Variant)value.getAttributes().get("org.eclipse.scada.da.level.floor.preset")).asDouble());
            logger.info("Floor set successfully: {}", (Object)this.floor);
        }
        catch (NullValueException nullValueException) {
            logger.info("Could not set floor");
        }
        catch (NotConvertableException notConvertableException) {
            logger.info("Could not set floor");
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Could not set floor");
        }
    }

    protected void setText(Text text, Map<String, DataValue> values, String attribute) {
        Variant value;
        if (attribute == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(attribute);
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        }
        text.setText(value != null ? value.asString("") : "");
    }

    protected void setTextDecimal(Text text, DataItemValue value) {
        if (value == null) {
            text.setText("");
            return;
        }
        if (value.getValue().isNull()) {
            text.setText("");
            return;
        }
        try {
            if (this.decimalFormat == null) {
                text.setText(value.getValue().asString());
            } else {
                try {
                    text.setText(this.decimalFormat.format(value.getValue().asDouble()));
                }
                catch (NotConvertableException e) {
                    text.setText("?");
                    logger.error("Could not convert and show double value: {}", (Throwable)e);
                }
            }
        }
        catch (NullValueException nullValueException) {
            text.setText("null");
            logger.info("No valid data to show value");
        }
    }

    protected String getFormattedText(Map<String, DataValue> values, String attribute) {
        if (this.isText) {
            return this.getText(values, attribute);
        }
        return this.getTextDecimal(values, attribute);
    }

    protected Double parseDecimal(String text) throws ParseException {
        return this.decimalFormat.parse(text).doubleValue();
    }
}

