/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi;

import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.osgi.AuthorizationManager;
import org.eclipse.scada.sec.osgi.Messages;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingAuthorizationImplementation
implements AuthorizationImplementation {
    private static final Logger logger = LoggerFactory.getLogger(TrackingAuthorizationImplementation.class);
    private final SingleServiceTracker<AuthorizationManager> tracker;

    public TrackingAuthorizationImplementation(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, AuthorizationManager.class, null);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public NotifyFuture<AuthorizationReply> authorize(AuthorizationContext context, AuthorizationResult defaultResult) {
        logger.trace("Authorizing - {}", (Object)context);
        AuthorizationManager service = (AuthorizationManager)this.tracker.getService();
        if (service == null) {
            logger.info("We don't have an authorization manager");
            return new InstantErrorFuture((Throwable)new AuthenticationException(StatusCodes.AUTHORIZATION_FAILED, Messages.getString("TrackingAuthenticationImplementation.DefaultMessage")));
        }
        return service.authorize(context, defaultResult);
    }
}

