/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.osgi.AuthorizationHelper;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingAuthorizationTracker
implements AuthorizationTracker {
    private static final Logger logger = LoggerFactory.getLogger(TrackingAuthorizationTracker.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private final SingleServiceListener<AuthorizationTracker> listener = new SingleServiceListener<AuthorizationTracker>(){

        public void serviceChange(ServiceReference<AuthorizationTracker> reference, AuthorizationTracker service) {
            TrackingAuthorizationTracker.this.setService(service);
        }
    };
    private final SingleServiceTracker<AuthorizationTracker> tracker;
    private final Set<MonitorImpl> monitors = new HashSet<MonitorImpl>();
    private AuthorizationTracker service;
    private ExportedExecutorService executor;

    public TrackingAuthorizationTracker(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, AuthorizationTracker.class, this.listener);
    }

    public void open() {
        this.executor = new ExportedExecutorService(TrackingAuthorizationTracker.getName(), 1, 1, 1L, TimeUnit.MINUTES);
        this.tracker.open();
    }

    private static String getName() {
        return String.format("%s/%s", TrackingAuthorizationTracker.class.getName(), INSTANCE_COUNT.incrementAndGet());
    }

    public void close() {
        this.tracker.close();
        this.executor.shutdown();
    }

    protected synchronized void setService(AuthorizationTracker service) {
        this.service = service;
        for (MonitorImpl monitor : this.monitors) {
            monitor.setService(service);
        }
    }

    public synchronized void disposeMonitor(MonitorImpl monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public synchronized AuthorizationTracker.Monitor createMonitor(AuthorizationTracker.Listener listener, AuthorizationRequest request) {
        logger.debug("Creating monitor - listener: {}, request: {}", (Object)listener, (Object)request);
        MonitorImpl monitor = new MonitorImpl(listener, request, (Executor)this.executor);
        monitor.setService(this.service);
        this.monitors.add(monitor);
        return monitor;
    }

    private class MonitorImpl
    implements AuthorizationTracker.Monitor {
        private final AuthorizationTracker.Listener listener;
        private final AuthorizationRequest request;
        private AuthorizationTracker.Monitor monitor;
        private boolean disposed;
        private final Executor executor;
        private final AuthorizationContext context;

        public MonitorImpl(AuthorizationTracker.Listener listener, AuthorizationRequest request, Executor executor) {
            this.listener = listener;
            this.request = request;
            this.executor = executor;
            this.context = new AuthorizationContext();
            this.context.setRequest(request);
        }

        public synchronized void setService(AuthorizationTracker authorizationTracker) {
            logger.debug("Setting service - disposed: {}, monitor: {}, service: {}", new Object[]{this.disposed, this.monitor, authorizationTracker});
            if (this.disposed) {
                return;
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
            if (authorizationTracker != null) {
                this.monitor = authorizationTracker.createMonitor(this.listener, this.request);
            } else {
                this.fireListener(AuthorizationReply.create((AuthorizationResult)AuthorizationHelper.DEFAULT_RESULT, (AuthorizationContext)this.context));
            }
        }

        protected void fireListener(final AuthorizationReply result) {
            logger.debug("Fire listener - request: {}, result: {}", (Object)this.request, (Object)result);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MonitorImpl.this.listener.resultChanged(result);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            logger.debug("Dispose");
            MonitorImpl monitorImpl = this;
            synchronized (monitorImpl) {
                this.disposed = true;
                if (this.disposed) {
                    return;
                }
                this.monitor.dispose();
                this.monitor = null;
            }
            TrackingAuthorizationTracker.this.disposeMonitor(this);
        }
    }
}

