/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.data;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.ConnectionDiscoveryListener;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.ui.IActionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDiscovererBean
implements IAdaptable,
ConnectionDiscoveryListener,
IActionFilter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionDiscovererBean.class);
    private final String id;
    private final String name;
    private final String description;
    private final ConnectionDiscoverer discoverer;
    private final ImageDescriptor imageDescriptor;
    private final WritableSet knownConnections = new WritableSet();
    private final Map<ConnectionDescriptor, ConnectionHolder> connections = new HashMap<ConnectionDescriptor, ConnectionHolder>();

    public ConnectionDiscovererBean(String id, String name, String description, ImageDescriptor imageDescriptor, ConnectionDiscoverer discoverer) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.discoverer = discoverer;
        this.imageDescriptor = imageDescriptor;
        this.register();
    }

    private void register() {
        this.discoverer.addConnectionListener(this);
    }

    public IObservableSet getKnownConnections() {
        return Observables.proxyObservableSet((IObservableSet)this.knownConnections);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.id;
    }

    public Object getAdapter(Class adapter) {
        logger.info("Get adaper: {}", (Object)adapter);
        if (adapter == ConnectionDiscoverer.class) {
            return this.discoverer;
        }
        if (adapter == ConnectionStore.class && this.discoverer instanceof ConnectionStore) {
            return this.discoverer;
        }
        if (this.discoverer instanceof IAdaptable) {
            return ((IAdaptable)this.discoverer).getAdapter(adapter);
        }
        return null;
    }

    @Override
    public void discoveryUpdate(final ConnectionDescriptor[] added, final ConnectionDescriptor[] removed) {
        this.knownConnections.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionDiscovererBean.this.handleDiscoveryUpdate(added, removed);
            }
        });
    }

    protected void handleDiscoveryUpdate(ConnectionDescriptor[] added, ConnectionDescriptor[] removed) {
        ConnectionHolder holder;
        ConnectionDescriptor info;
        int n;
        int n2;
        ConnectionDescriptor[] connectionDescriptorArray;
        if (removed != null) {
            connectionDescriptorArray = removed;
            n2 = removed.length;
            n = 0;
            while (n < n2) {
                info = connectionDescriptorArray[n];
                holder = this.connections.remove(info);
                if (holder != null) {
                    this.knownConnections.remove((Object)holder);
                    holder.dispose();
                }
                ++n;
            }
        }
        if (added != null) {
            connectionDescriptorArray = added;
            n2 = added.length;
            n = 0;
            while (n < n2) {
                info = connectionDescriptorArray[n];
                holder = new ConnectionHolder(this, info);
                this.knownConnections.add((Object)holder);
                this.connections.put(info, holder);
                ++n;
            }
        }
    }

    public ConnectionStore getStore() {
        if (this.discoverer instanceof ConnectionStore) {
            return (ConnectionStore)((Object)this.discoverer);
        }
        return null;
    }

    public boolean isStore() {
        return this.discoverer instanceof ConnectionStore;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if ("isStore".equals(name)) {
            return this.isStore() == Boolean.valueOf(value).booleanValue();
        }
        return false;
    }
}

