/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.data;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.Activator;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionManager;
import org.eclipse.scada.core.ui.connection.data.PropertySourceWrapper;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHolder
extends AbstractPropertyChange
implements ConnectionStateListener,
IAdaptable {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionHolder.class);
    public static final String PROP_CONNECTION_SERVICE = "connectionService";
    public static final String PROP_CONNECTION_STATE = "connectionState";
    public static final String PROP_CONNECTION_ERROR = "connectionError";
    private final ConnectionDescriptor info;
    private final ConnectionDiscovererBean discoverer;
    private volatile ConnectionService connectionService;
    private volatile ConnectionState connectionState;
    private Throwable connectionError;
    private ConnectionManager.Entry entry;

    public ConnectionHolder(ConnectionDiscovererBean discoverer, ConnectionDescriptor info) {
        this.info = info;
        this.discoverer = discoverer;
        this.createConnection();
    }

    private synchronized void createConnection() {
        this.entry = Activator.getDefaultConectionManager().getConnection(this.info);
        if (this.entry != null) {
            this.entry.getConnectionService().getConnection().addConnectionStateListener((ConnectionStateListener)this);
            this.setConnectionService(this.entry.getConnectionService());
            this.setConnectionState(ConnectionState.CLOSED);
            this.setConnectionError(null);
        }
    }

    private synchronized void destroyConnection() {
        if (this.entry != null) {
            this.entry.getConnectionService().getConnection().removeConnectionStateListener((ConnectionStateListener)this);
            this.entry.dispose();
        }
        this.setConnectionService(null);
        this.setConnectionState(null);
        this.setConnectionError(null);
    }

    public synchronized void connect() {
        if (this.connectionService != null) {
            this.connectionService.connect();
        }
    }

    public synchronized void disconnect() {
        if (this.connectionService != null) {
            this.connectionService.disconnect();
        }
    }

    public ConnectionDiscovererBean getDiscoverer() {
        return this.discoverer;
    }

    public String toString() {
        return this.info.toString();
    }

    public void dispose() {
        this.destroyConnection();
    }

    public ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public ConnectionDescriptor getConnectionInformation() {
        return this.info;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    protected void setConnectionState(ConnectionState connectionState) {
        ConnectionState oldConnectionState = this.connectionState;
        this.connectionState = connectionState;
        this.firePropertyChange(PROP_CONNECTION_STATE, oldConnectionState, connectionState);
    }

    public Throwable getConnectionError() {
        return this.connectionError;
    }

    protected void setConnectionService(ConnectionService connectionService) {
        ConnectionService oldConnectionService = connectionService;
        this.connectionService = connectionService;
        this.firePropertyChange(PROP_CONNECTION_SERVICE, oldConnectionService, connectionService);
    }

    protected void setConnectionError(Throwable connectionError) {
        Throwable oldConnectionError = connectionError;
        this.connectionError = connectionError;
        this.firePropertyChange(PROP_CONNECTION_ERROR, oldConnectionError, connectionError);
    }

    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        logger.debug("Connection state changed: {}", (Object)state);
        this.setConnectionState(state);
        this.setConnectionError(error);
    }

    public Object getAdapter(Class adapter) {
        logger.debug("Adapting: {}", (Object)adapter);
        if (adapter == ConnectionService.class) {
            return this.connectionService;
        }
        if (adapter == IPropertySource.class) {
            return new PropertySourceWrapper(this);
        }
        return null;
    }

    public void setConnectCallbackHandler(CallbackHandler callbackHandler) {
        if (this.connectionService != null) {
            this.connectionService.setConnectCallbackHandler(callbackHandler);
        }
    }

    public void connect(DisplayCallbackHandler callbackHandler) {
        this.setConnectCallbackHandler((CallbackHandler)callbackHandler);
        this.connect();
    }
}

