/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.connection.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.AbstractConnectionManager;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionProvider.class);
    protected final ServiceTracker<ConnectionRequest, ConnectionRequest> tracker;
    protected final BundleContext context;
    private final Map<ConnectionInformation, AbstractConnectionManager> connections = new HashMap<ConnectionInformation, AbstractConnectionManager>();
    private final Map<String, AbstractConnectionManager> privateConnections = new HashMap<String, AbstractConnectionManager>();

    protected abstract AbstractConnectionManager createConnectionManager(ConnectionRequest var1);

    public AbstractConnectionProvider(BundleContext context, String interfaceName) {
        this.context = context;
        Filter filter = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("interface", interfaceName);
            filter = FilterUtil.createAndFilter((String)ConnectionRequest.class.getName(), parameters);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("Failed to create filter", (Throwable)e);
        }
        this.tracker = filter != null ? new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConnectionRequest, ConnectionRequest>(){

            public void removedService(ServiceReference<ConnectionRequest> reference, ConnectionRequest service) {
                AbstractConnectionProvider.this.removedService(reference, service);
            }

            public void modifiedService(ServiceReference<ConnectionRequest> reference, ConnectionRequest service) {
                AbstractConnectionProvider.this.modifiedService(reference, service);
            }

            public ConnectionRequest addingService(ServiceReference<ConnectionRequest> reference) {
                return AbstractConnectionProvider.this.addingService(reference);
            }
        }) : null;
    }

    public synchronized void start() {
        this.tracker.open();
    }

    public synchronized void stop() {
        this.tracker.close();
    }

    protected ConnectionRequest addingService(ServiceReference<ConnectionRequest> reference) {
        Object o = this.context.getService(reference);
        try {
            ConnectionRequest request = (ConnectionRequest)o;
            this.addRequest(request);
            o = null;
            return request;
        }
        catch (Throwable throwable) {
            if (o != null) {
                this.context.ungetService(reference);
            }
            return null;
        }
    }

    protected void modifiedService(ServiceReference<ConnectionRequest> reference, Object service) {
        if (service instanceof ConnectionRequest) {
            this.removeRequest((ConnectionRequest)service);
            this.addRequest((ConnectionRequest)service);
        }
    }

    protected void removedService(ServiceReference<ConnectionRequest> reference, Object service) {
        logger.debug("Removed service: {}", reference);
        if (service instanceof ConnectionRequest) {
            this.removeRequest((ConnectionRequest)service);
        }
    }

    private synchronized void removeRequest(ConnectionRequest request) {
        logger.info("Request removed: {}", (Object)request);
        String requestId = request.getRequestId();
        if (requestId == null) {
            AbstractConnectionManager manager = this.connections.get(request.getConnectionInformation());
            if (manager == null) {
                logger.warn("Unknown request: {}", (Object)request);
                return;
            }
            manager.removeRequest(request);
            if (manager.isIdle()) {
                logger.info("Dropping connection");
                this.connections.remove(request.getConnectionInformation());
                manager.dispose();
            }
        } else {
            AbstractConnectionManager manager = this.privateConnections.get(requestId);
            if (manager == null) {
                logger.warn("Unknown request: {}", (Object)requestId);
                return;
            }
            manager.removeRequest(request);
            if (manager.isIdle()) {
                logger.info("Dropping private connection");
                this.privateConnections.remove(requestId);
                manager.dispose();
            }
        }
    }

    private synchronized void addRequest(ConnectionRequest request) {
        logger.info("Found new request: {}", (Object)request);
        String requestId = request.getRequestId();
        if (requestId == null) {
            AbstractConnectionManager manager = this.connections.get(request.getConnectionInformation());
            if (manager == null) {
                logger.info("Create new connection: {}", (Object)request);
                manager = this.createConnectionManager(request);
                this.connections.put(request.getConnectionInformation(), manager);
            }
            manager.addRequest(request);
        } else {
            AbstractConnectionManager manager = this.privateConnections.get(requestId);
            if (manager == null) {
                logger.info("Create new private connection: {} -> {}", new Object[]{request, requestId});
                manager = this.createConnectionManager(request);
                this.privateConnections.put(requestId, manager);
            }
            manager.addRequest(request);
        }
    }
}

