/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.connection.provider;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionRequestTracker
extends ConnectionTracker {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionRequestTracker.class);
    private final ConnectionRequest request;
    private ServiceRegistration<ConnectionRequest> handle;
    private final BundleContext context;

    public ConnectionRequestTracker(BundleContext context, ConnectionRequest request, ConnectionTracker.Listener listener) {
        this(context, request, listener, null);
    }

    public ConnectionRequestTracker(BundleContext context, ConnectionRequest request, ConnectionTracker.Listener listener, Class<? extends ConnectionService> clazz) {
        super(context, listener, clazz);
        this.context = context;
        this.request = request;
    }

    @Override
    protected Map<String, String> createFilterParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("connection.uri", this.request.getConnectionInformation().toString());
        if (this.request.getRequestId() != null) {
            parameters.put("service.pid", this.request.getRequestId());
        }
        return parameters;
    }

    public synchronized void request() {
        if (this.handle == null && this.request != null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("driver", this.request.getConnectionInformation().getDriver());
            ((Dictionary)properties).put("interface", this.request.getConnectionInformation().getInterface());
            this.handle = this.context.registerService(ConnectionRequest.class, (Object)this.request, properties);
        }
    }

    public synchronized void unrequest() {
        if (this.handle != null) {
            logger.debug("Unregister handle: {}", this.handle);
            this.handle.unregister();
            this.handle = null;
        }
    }

    @Override
    public synchronized void open() {
        super.open();
        this.request();
    }

    @Override
    public synchronized void close() {
        this.unrequest();
        super.close();
    }

    public ConnectionInformation getConnectionInformation() {
        return this.request.getConnectionInformation();
    }
}

