/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.client.ngp.BrowserManager;
import org.eclipse.scada.ae.client.ngp.EventManager;
import org.eclipse.scada.ae.client.ngp.MonitorManager;
import org.eclipse.scada.ae.client.ngp.QueryManager;
import org.eclipse.scada.ae.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.data.message.AcknowledgeRequest;
import org.eclipse.scada.ae.data.message.AcknowledgeResponse;
import org.eclipse.scada.ae.data.message.BrowseData;
import org.eclipse.scada.ae.data.message.CloseQuery;
import org.eclipse.scada.ae.data.message.CreateQuery;
import org.eclipse.scada.ae.data.message.EventPoolDataUpdate;
import org.eclipse.scada.ae.data.message.EventPoolStatusUpdate;
import org.eclipse.scada.ae.data.message.LoadMore;
import org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate;
import org.eclipse.scada.ae.data.message.MonitorPoolStatusUpdate;
import org.eclipse.scada.ae.data.message.StartBrowse;
import org.eclipse.scada.ae.data.message.StopBrowse;
import org.eclipse.scada.ae.data.message.SubscribeEventPool;
import org.eclipse.scada.ae.data.message.SubscribeMonitorPool;
import org.eclipse.scada.ae.data.message.UnsubscribeEventPool;
import org.eclipse.scada.ae.data.message.UnsubscribeMonitorPool;
import org.eclipse.scada.ae.data.message.UpdateQueryData;
import org.eclipse.scada.ae.data.message.UpdateQueryState;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ngp.ConnectionBaseImpl;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.ExecutorFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ConnectionBaseImpl
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    private final BrowserManager browserManager;
    private final MonitorManager monitorManager;
    private final EventManager eventManager;
    private final QueryManager queryManager;

    public ConnectionImpl(ConnectionInformation connectionInformation) throws Exception {
        super((ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), connectionInformation);
        this.browserManager = new BrowserManager(this.executor, this);
        this.monitorManager = new MonitorManager(this.executor, this);
        this.eventManager = new EventManager(this.executor, this);
        this.queryManager = new QueryManager(this.executor, this);
    }

    public synchronized void dispose() {
        this.browserManager.dispose();
        this.monitorManager.dispose();
        this.eventManager.dispose();
        this.queryManager.dispose();
        super.dispose();
    }

    protected void onConnectionClosed() {
        super.onConnectionClosed();
        this.browserManager.onClosed();
        this.monitorManager.onClosed();
        this.eventManager.onClosed();
        this.queryManager.onClosed();
    }

    protected void onConnectionBound() {
        super.onConnectionBound();
        this.browserManager.onBound();
        this.monitorManager.onBound();
        this.eventManager.onBound();
        this.queryManager.onBound();
    }

    public synchronized void addBrowserListener(BrowserListener listener) {
        this.browserManager.addBrowserListener(listener);
    }

    public synchronized void removeBrowserListener(BrowserListener listener) {
        this.browserManager.removeBrowserListener(listener);
    }

    public synchronized void setEventListener(String eventQueryId, EventListener listener) {
        this.eventManager.setEventListener(eventQueryId, listener);
    }

    public synchronized void setMonitorListener(String monitorQueryId, MonitorListener listener) {
        this.monitorManager.setMonitorListener(monitorQueryId, listener);
    }

    public synchronized Query createQuery(String queryType, String queryData, QueryListener listener) {
        if (this.getState() != ConnectionState.BOUND) {
            return new DisconnectedQuery(this.executor, listener, new IllegalStateException("Connection is not BOUND").fillInStackTrace());
        }
        return this.queryManager.createQuery(queryType, queryData, listener);
    }

    public NotifyFuture<Void> acknowledge(String monitorId, Date aknTimestamp, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        Request request = this.nextRequest();
        Long callbackHandlerId = this.registerCallbackHandler(request, callbackHandler);
        return new AcknowledgeFuture(this.executor, (NotifyFuture<ResponseMessage>)this.sendRequestMessage((RequestMessage)new AcknowledgeRequest(this.nextRequest(), monitorId, ConnectionImpl.makeTimestamp(aknTimestamp), operationParameters, callbackHandlerId)));
    }

    protected synchronized void handleMessage(Object message) {
        if (message instanceof MonitorPoolDataUpdate) {
            this.handleMonitorPoolDataUpdate((MonitorPoolDataUpdate)message);
        } else if (message instanceof MonitorPoolStatusUpdate) {
            this.handleMonitorPoolStatusUpdate((MonitorPoolStatusUpdate)message);
        }
        if (message instanceof EventPoolDataUpdate) {
            this.handleEventPoolDataUpdate((EventPoolDataUpdate)message);
        } else if (message instanceof EventPoolStatusUpdate) {
            this.handleEventPoolStatusUpdate((EventPoolStatusUpdate)message);
        } else if (message instanceof UpdateQueryData) {
            this.handleUpdateQueryData((UpdateQueryData)message);
        } else if (message instanceof UpdateQueryState) {
            this.handleUpdateQueryState((UpdateQueryState)message);
        } else if (message instanceof BrowseData) {
            this.handleBrowseData((BrowseData)message);
        } else {
            super.handleMessage(message);
        }
    }

    private void handleBrowseData(BrowseData message) {
        this.browserManager.updateData(message.getAddedOrUpdated(), message.getRemoved());
    }

    private void handleUpdateQueryState(UpdateQueryState message) {
        this.queryManager.updateQueryState(message.getQueryId(), message.getState(), message.getError());
    }

    private void handleUpdateQueryData(UpdateQueryData message) {
        this.queryManager.updateQueryData(message.getQueryId(), message.getEvents());
    }

    private void handleMonitorPoolStatusUpdate(MonitorPoolStatusUpdate message) {
        this.monitorManager.handleStatusUpdate(message.getMonitorPoolId(), message.getState());
    }

    private void handleMonitorPoolDataUpdate(MonitorPoolDataUpdate message) {
        this.monitorManager.handleDataUpdate(message.getMonitorPoolId(), message.getAddedOrUpdated(), message.getRemoved(), message.isFull());
    }

    private void handleEventPoolStatusUpdate(EventPoolStatusUpdate message) {
        this.eventManager.handleStatusUpdate(message.getEventPoolId(), message.getState());
    }

    private void handleEventPoolDataUpdate(EventPoolDataUpdate message) {
        this.eventManager.handleDataUpdate(message.getEventPoolId(), message.getAddedEvents());
    }

    public void sendStartBrowse() {
        logger.debug("Starting browsing");
        this.sendMessage(new StartBrowse());
    }

    public void sendStopBrowse() {
        logger.debug("Stop browsing");
        this.sendMessage(new StopBrowse());
    }

    public void sendSubscribeMonitorPool(String monitorPoolId) {
        logger.debug("Subscribe to monitor pool: {}", (Object)monitorPoolId);
        this.sendMessage(new SubscribeMonitorPool(monitorPoolId));
    }

    public void sendUnsubscribeMonitorPool(String monitorPoolId) {
        logger.debug("Unsubscribe from monitor pool: {}", (Object)monitorPoolId);
        this.sendMessage(new UnsubscribeMonitorPool(monitorPoolId));
    }

    public void sendSubscribeEventPool(String eventPoolId) {
        logger.debug("Subscribe to event pool: {}", (Object)eventPoolId);
        this.sendMessage(new SubscribeEventPool(eventPoolId));
    }

    public void sendUnsubscribeEventPool(String eventPoolId) {
        logger.debug("Unsubscribe from event pool: {}", (Object)eventPoolId);
        this.sendMessage(new UnsubscribeEventPool(eventPoolId));
    }

    private static Long makeTimestamp(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }

    public void sendCloseQuery(long queryId) {
        this.sendMessage(new CloseQuery(queryId));
    }

    public void sendLoadMore(long queryId, int count) {
        this.sendMessage(new LoadMore(queryId, count));
    }

    public void sendCreateQuery(long queryId, String queryType, String queryData) {
        this.sendMessage(new CreateQuery(queryId, queryType, queryData));
    }

    public static class AcknowledgeFuture
    extends ExecutorFuture<Void>
    implements FutureListener<ResponseMessage> {
        public AcknowledgeFuture(Executor executor, NotifyFuture<ResponseMessage> future) {
            super(executor);
            future.addListener((FutureListener)this);
        }

        public void complete(Future<ResponseMessage> future) {
            try {
                ResponseMessage response = future.get();
                if (response instanceof AcknowledgeResponse) {
                    if (((AcknowledgeResponse)response).getErrorInformation() == null) {
                        this.setResult(null);
                    } else {
                        this.setError(new OperationException(((AcknowledgeResponse)response).getErrorInformation().getMessage()).fillInStackTrace());
                    }
                } else {
                    this.setError(new IllegalStateException(String.format("Wrong reply - expected: %s, got: %s", AcknowledgeResponse.class, response)));
                }
            }
            catch (Exception e) {
                this.setError(e);
            }
        }
    }

    public static class DisconnectedQuery
    implements Query {
        public DisconnectedQuery(ExecutorService executor, final QueryListener listener, final Throwable error) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.queryStateChanged(QueryState.DISCONNECTED, error);
                }
            });
        }

        public void loadMore(int count) {
        }

        public void close() {
        }
    }
}

