/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.client.ngp.ConnectionImpl;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorManager {
    private static final Logger logger = LoggerFactory.getLogger(MonitorManager.class);
    private final Map<String, MonitorListener> monitorListeners = new HashMap<String, MonitorListener>();
    private final Executor executor;
    private final ConnectionImpl connection;

    public MonitorManager(Executor executor, ConnectionImpl connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public void setMonitorListener(String monitorQueryId, MonitorListener listener) {
        if (listener == null) {
            this.clearMonitorListener(monitorQueryId);
        } else {
            this.updateMonitorListener(monitorQueryId, listener);
        }
    }

    private void updateMonitorListener(String monitorQueryId, MonitorListener listener) {
        MonitorListener oldListener = this.monitorListeners.put(monitorQueryId, listener);
        if (oldListener == listener) {
            return;
        }
        if (oldListener != null) {
            this.fireMonitorStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        } else {
            this.sendSubscribeMonitors(monitorQueryId, true);
        }
        this.fireMonitorStatusChange(listener, SubscriptionState.DISCONNECTED);
    }

    private void clearMonitorListener(String monitorQueryId) {
        MonitorListener oldListener = this.monitorListeners.remove(monitorQueryId);
        if (oldListener != null) {
            this.sendSubscribeMonitors(monitorQueryId, false);
        }
        if (oldListener != null) {
            this.fireMonitorStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        }
    }

    private void fireMonitorStatusChange(final MonitorListener listener, final SubscriptionState status) {
        if (listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.statusChanged(status);
            }
        });
    }

    private void sendSubscribeMonitors(String monitorPoolId, boolean flag) {
        logger.info("Requesting monitors: {}/{}", (Object)monitorPoolId, (Object)flag);
        if (flag) {
            this.connection.sendSubscribeMonitorPool(monitorPoolId);
        } else {
            this.connection.sendUnsubscribeMonitorPool(monitorPoolId);
        }
    }

    private void fireMonitorDataChange(final MonitorListener listener, final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        if (listener == null) {
            logger.warn("Monitor change data without a listener");
            return;
        }
        try {
            logger.debug("notify condition data change");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(addedOrUpdated, removed, full);
                }
            });
        }
        catch (Throwable e) {
            logger.warn("Failed to notify", e);
        }
    }

    public void dispose() {
        this.monitorListeners.clear();
    }

    public void onClosed() {
        for (MonitorListener listener : this.monitorListeners.values()) {
            this.fireMonitorStatusChange(listener, SubscriptionState.DISCONNECTED);
            this.fireMonitorDataChange(listener, Collections.<MonitorStatusInformation>emptyList(), Collections.<String>emptySet(), true);
        }
    }

    public void onBound() {
        for (String id : this.monitorListeners.keySet()) {
            this.connection.sendSubscribeMonitorPool(id);
        }
    }

    public void handleDataUpdate(String monitorPoolId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        MonitorListener listener = this.monitorListeners.get(monitorPoolId);
        this.fireMonitorDataChange(listener, addedOrUpdated, removed, full);
    }

    public void handleStatusUpdate(String monitorPoolId, SubscriptionState state) {
        MonitorListener listener = this.monitorListeners.get(monitorPoolId);
        this.fireMonitorStatusChange(listener, state);
    }
}

