/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.protocol.ngp.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.CallbackRequest;
import org.eclipse.scada.core.data.CallbackResponse;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.data.UserInformation;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Structures {
    private static final Logger logger = LoggerFactory.getLogger(Structures.class);
    private static final ArrayListAllocator<ErrorInformation> ALLOC_ERRORINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<ErrorInformation> ALLOC_ERRORINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Request> ALLOC_REQUEST_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Request> ALLOC_REQUEST_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Response> ALLOC_RESPONSE_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Response> ALLOC_RESPONSE_SET = new HashSetAllocator();
    private static final ArrayListAllocator<UserInformation> ALLOC_USERINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<UserInformation> ALLOC_USERINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<OperationParameters> ALLOC_OPERATIONPARAMETERS_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<OperationParameters> ALLOC_OPERATIONPARAMETERS_SET = new HashSetAllocator();
    private static final ArrayListAllocator<CallbackRequest> ALLOC_CALLBACKREQUEST_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<CallbackRequest> ALLOC_CALLBACKREQUEST_SET = new HashSetAllocator();
    private static final ArrayListAllocator<CallbackResponse> ALLOC_CALLBACKRESPONSE_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<CallbackResponse> ALLOC_CALLBACKRESPONSE_SET = new HashSetAllocator();

    private Structures() {
    }

    protected static void inlineEncodeErrorInformation(BinaryContext context, IoBuffer data, ErrorInformation value) throws Exception {
        data.put((byte)3);
        context.encodeLong(data, (byte)1, value.getCode());
        context.encodeString(data, (byte)2, value.getMessage());
        context.encodeString(data, (byte)3, value.getDiagnosticInformation());
    }

    protected static ErrorInformation inlindeDecodeErrorInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        Long code = null;
        String message = null;
        String diagnosticInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    code = _context.decodeLong(_data);
                    break;
                }
                case 2: {
                    message = _context.decodeString(_data);
                    break;
                }
                case 3: {
                    diagnosticInformation = _context.decodeString(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new ErrorInformation(code, message, diagnosticInformation);
    }

    public static void encodeErrorInformation(BinaryContext context, IoBuffer data, byte fieldNumber, ErrorInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeErrorInformation(context, data, value);
        }
    }

    public static void encodeCollectionErrorInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<ErrorInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (ErrorInformation entry : values) {
            Structures.inlineEncodeErrorInformation(context, data, entry);
        }
    }

    public static ErrorInformation decodeErrorInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeErrorInformation(context, data);
    }

    protected static void fillErrorInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<ErrorInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeErrorInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<ErrorInformation>> T decodeErrorInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<ErrorInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillErrorInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<ErrorInformation> decodeListErrorInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeErrorInformationCollection(context, data, ALLOC_ERRORINFORMATION_LIST, allowNull);
    }

    public static Set<ErrorInformation> decodeSetErrorInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeErrorInformationCollection(context, data, ALLOC_ERRORINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeRequest(BinaryContext context, IoBuffer data, Request value) throws Exception {
        data.put((byte)1);
        context.encodePrimitiveLong(data, (byte)1, value.getRequestId());
    }

    protected static Request inlindeDecodeRequest(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        long requestId = 0L;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    requestId = _context.decodePrimitiveLong(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new Request(requestId);
    }

    public static void encodeRequest(BinaryContext context, IoBuffer data, byte fieldNumber, Request value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeRequest(context, data, value);
        }
    }

    public static void encodeCollectionRequest(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<Request> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (Request entry : values) {
            Structures.inlineEncodeRequest(context, data, entry);
        }
    }

    public static Request decodeRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeRequest(context, data);
    }

    protected static void fillRequestCollection(BinaryContext context, IoBuffer data, int items, Collection<Request> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeRequest(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<Request>> T decodeRequestCollection(BinaryContext context, IoBuffer data, CollectionAllocator<Request, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillRequestCollection(context, data, len, result);
        return (T)result;
    }

    public static List<Request> decodeListRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeRequestCollection(context, data, ALLOC_REQUEST_LIST, allowNull);
    }

    public static Set<Request> decodeSetRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeRequestCollection(context, data, ALLOC_REQUEST_SET, allowNull);
    }

    protected static void inlineEncodeResponse(BinaryContext context, IoBuffer data, Response value) throws Exception {
        data.put((byte)1);
        Structures.encodeRequest(context, data, (byte)1, value.getRequest());
    }

    protected static Response inlindeDecodeResponse(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        Request request = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    request = Structures.decodeRequest(_context, _data, false);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new Response(request);
    }

    public static void encodeResponse(BinaryContext context, IoBuffer data, byte fieldNumber, Response value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeResponse(context, data, value);
        }
    }

    public static void encodeCollectionResponse(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<Response> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (Response entry : values) {
            Structures.inlineEncodeResponse(context, data, entry);
        }
    }

    public static Response decodeResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeResponse(context, data);
    }

    protected static void fillResponseCollection(BinaryContext context, IoBuffer data, int items, Collection<Response> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeResponse(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<Response>> T decodeResponseCollection(BinaryContext context, IoBuffer data, CollectionAllocator<Response, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillResponseCollection(context, data, len, result);
        return (T)result;
    }

    public static List<Response> decodeListResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeResponseCollection(context, data, ALLOC_RESPONSE_LIST, allowNull);
    }

    public static Set<Response> decodeSetResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeResponseCollection(context, data, ALLOC_RESPONSE_SET, allowNull);
    }

    protected static void inlineEncodeUserInformation(BinaryContext context, IoBuffer data, UserInformation value) throws Exception {
        data.put((byte)1);
        context.encodeString(data, (byte)1, value.getName());
    }

    protected static UserInformation inlindeDecodeUserInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String name = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    name = _context.decodeString(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new UserInformation(name);
    }

    public static void encodeUserInformation(BinaryContext context, IoBuffer data, byte fieldNumber, UserInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeUserInformation(context, data, value);
        }
    }

    public static void encodeCollectionUserInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<UserInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (UserInformation entry : values) {
            Structures.inlineEncodeUserInformation(context, data, entry);
        }
    }

    public static UserInformation decodeUserInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeUserInformation(context, data);
    }

    protected static void fillUserInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<UserInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeUserInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<UserInformation>> T decodeUserInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<UserInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillUserInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<UserInformation> decodeListUserInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeUserInformationCollection(context, data, ALLOC_USERINFORMATION_LIST, allowNull);
    }

    public static Set<UserInformation> decodeSetUserInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeUserInformationCollection(context, data, ALLOC_USERINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeOperationParameters(BinaryContext context, IoBuffer data, OperationParameters value) throws Exception {
        data.put((byte)2);
        Structures.encodeUserInformation(context, data, (byte)1, value.getUserInformation());
        context.encodeProperties(data, (byte)2, value.getProperties());
    }

    protected static OperationParameters inlindeDecodeOperationParameters(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        UserInformation userInformation = null;
        Map properties = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    userInformation = Structures.decodeUserInformation(_context, _data, true);
                    break;
                }
                case 2: {
                    properties = _context.decodeProperties(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new OperationParameters(userInformation, properties);
    }

    public static void encodeOperationParameters(BinaryContext context, IoBuffer data, byte fieldNumber, OperationParameters value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeOperationParameters(context, data, value);
        }
    }

    public static void encodeCollectionOperationParameters(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<OperationParameters> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (OperationParameters entry : values) {
            Structures.inlineEncodeOperationParameters(context, data, entry);
        }
    }

    public static OperationParameters decodeOperationParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeOperationParameters(context, data);
    }

    protected static void fillOperationParametersCollection(BinaryContext context, IoBuffer data, int items, Collection<OperationParameters> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeOperationParameters(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<OperationParameters>> T decodeOperationParametersCollection(BinaryContext context, IoBuffer data, CollectionAllocator<OperationParameters, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillOperationParametersCollection(context, data, len, result);
        return (T)result;
    }

    public static List<OperationParameters> decodeListOperationParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeOperationParametersCollection(context, data, ALLOC_OPERATIONPARAMETERS_LIST, allowNull);
    }

    public static Set<OperationParameters> decodeSetOperationParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeOperationParametersCollection(context, data, ALLOC_OPERATIONPARAMETERS_SET, allowNull);
    }

    protected static void inlineEncodeCallbackRequest(BinaryContext context, IoBuffer data, CallbackRequest value) throws Exception {
        data.put((byte)2);
        context.encodeString(data, (byte)1, value.getType());
        context.encodeProperties(data, (byte)2, value.getAttributes());
    }

    protected static CallbackRequest inlindeDecodeCallbackRequest(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String type = null;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    type = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    attributes = _context.decodeProperties(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new CallbackRequest(type, attributes);
    }

    public static void encodeCallbackRequest(BinaryContext context, IoBuffer data, byte fieldNumber, CallbackRequest value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeCallbackRequest(context, data, value);
        }
    }

    public static void encodeCollectionCallbackRequest(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<CallbackRequest> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (CallbackRequest entry : values) {
            Structures.inlineEncodeCallbackRequest(context, data, entry);
        }
    }

    public static CallbackRequest decodeCallbackRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeCallbackRequest(context, data);
    }

    protected static void fillCallbackRequestCollection(BinaryContext context, IoBuffer data, int items, Collection<CallbackRequest> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeCallbackRequest(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<CallbackRequest>> T decodeCallbackRequestCollection(BinaryContext context, IoBuffer data, CollectionAllocator<CallbackRequest, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillCallbackRequestCollection(context, data, len, result);
        return (T)result;
    }

    public static List<CallbackRequest> decodeListCallbackRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeCallbackRequestCollection(context, data, ALLOC_CALLBACKREQUEST_LIST, allowNull);
    }

    public static Set<CallbackRequest> decodeSetCallbackRequest(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeCallbackRequestCollection(context, data, ALLOC_CALLBACKREQUEST_SET, allowNull);
    }

    protected static void inlineEncodeCallbackResponse(BinaryContext context, IoBuffer data, CallbackResponse value) throws Exception {
        data.put((byte)2);
        context.encodePrimitiveBoolean(data, (byte)1, value.isCanceled());
        context.encodeProperties(data, (byte)2, value.getAttributes());
    }

    protected static CallbackResponse inlindeDecodeCallbackResponse(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        boolean canceled = false;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    canceled = _context.decodePrimitiveBoolean(_data);
                    break;
                }
                case 2: {
                    attributes = _context.decodeProperties(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new CallbackResponse(canceled, attributes);
    }

    public static void encodeCallbackResponse(BinaryContext context, IoBuffer data, byte fieldNumber, CallbackResponse value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeCallbackResponse(context, data, value);
        }
    }

    public static void encodeCollectionCallbackResponse(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<CallbackResponse> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (CallbackResponse entry : values) {
            Structures.inlineEncodeCallbackResponse(context, data, entry);
        }
    }

    public static CallbackResponse decodeCallbackResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeCallbackResponse(context, data);
    }

    protected static void fillCallbackResponseCollection(BinaryContext context, IoBuffer data, int items, Collection<CallbackResponse> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeCallbackResponse(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<CallbackResponse>> T decodeCallbackResponseCollection(BinaryContext context, IoBuffer data, CollectionAllocator<CallbackResponse, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillCallbackResponseCollection(context, data, len, result);
        return (T)result;
    }

    public static List<CallbackResponse> decodeListCallbackResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeCallbackResponseCollection(context, data, ALLOC_CALLBACKRESPONSE_LIST, allowNull);
    }

    public static Set<CallbackResponse> decodeSetCallbackResponse(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeCallbackResponseCollection(context, data, ALLOC_CALLBACKRESPONSE_SET, allowNull);
    }
}

