/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptExecutor {
    private static final String PROP_NAME_DISABLE_COMPILE = "org.eclipse.scada.utils.script.ScriptExecutor.disableCompile";
    private final ScriptEngine engine;
    private final String command;
    private CompiledScript compiledScript;
    private final ClassLoader classLoader;
    private final URL commandUrl;
    private final String sourceName;

    private static ScriptEngine createEngine(ScriptEngineManager engineManager, String engineName) throws ScriptException {
        if (engineManager == null) {
            throw new IllegalArgumentException("Script engine manager must not be null");
        }
        if (engineName == null) {
            return null;
        }
        ScriptEngine engine = engineManager.getEngineByName(engineName);
        if (engine == null) {
            throw new ScriptException(String.format("Script engine '%s' could not be found", engineName));
        }
        return engine;
    }

    public ScriptExecutor(ScriptEngineManager engineManager, String engineName, String command, ClassLoader classLoader) throws ScriptException {
        this(ScriptExecutor.createEngine(engineManager, engineName), engineName == null ? null : command, classLoader);
    }

    public ScriptExecutor(ScriptEngineManager engineManager, String engineName, URL commandUrl, ClassLoader classLoader) throws ScriptException, IOException {
        this(ScriptExecutor.createEngine(engineManager, engineName), engineName == null ? null : commandUrl, classLoader);
    }

    public ScriptExecutor(ScriptEngine engine, String command, ClassLoader classLoader, String sourceName) throws ScriptException {
        this.engine = engine;
        this.command = command;
        this.commandUrl = null;
        this.classLoader = classLoader;
        this.sourceName = sourceName;
        if (command != null && engine instanceof Compilable && !Boolean.getBoolean(PROP_NAME_DISABLE_COMPILE)) {
            engine.put("javax.script.filename", sourceName);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                this.compiledScript = ((Compilable)((Object)engine)).compile(command);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    public ScriptExecutor(ScriptEngine engine, String command, ClassLoader classLoader) throws ScriptException {
        this(engine, command, classLoader, null);
    }

    public ScriptExecutor(ScriptEngine engine, URL commandUrl, ClassLoader classLoader) throws ScriptException, IOException {
        this.engine = engine;
        this.command = null;
        this.commandUrl = commandUrl;
        this.classLoader = classLoader;
        this.sourceName = commandUrl.toString();
        if (commandUrl != null && engine instanceof Compilable && !Boolean.getBoolean(PROP_NAME_DISABLE_COMPILE)) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                this.compiledScript = ((Compilable)((Object)engine)).compile(new InputStreamReader(commandUrl.openStream()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected Map<String, Object> applyVars(ScriptContext context, Map<String, Object> scriptObjects) {
        if (scriptObjects == null || scriptObjects.isEmpty()) {
            return null;
        }
        HashMap<String, Object> replaced = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : scriptObjects.entrySet()) {
            Object original = context.getAttribute(entry.getKey(), 100);
            replaced.put(entry.getKey(), original);
            context.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
        return replaced;
    }

    protected void restoreVars(ScriptContext context, Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            if (entry.getValue() == null) {
                context.removeAttribute(entry.getKey(), 100);
                continue;
            }
            context.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
    }

    private Object executeScript(ScriptContext scriptContext, Map<String, Object> scriptObjects) throws ScriptException, IOException {
        if (this.command == null && this.commandUrl == null && this.compiledScript == null) {
            return null;
        }
        Map<String, Object> vars = null;
        try {
            this.engine.put("javax.script.filename", this.sourceName);
            vars = this.applyVars(scriptContext, scriptObjects);
            if (this.compiledScript != null) {
                Object object = this.compiledScript.eval(scriptContext);
                return object;
            }
            if (this.command != null) {
                Object object = this.engine.eval(this.command, scriptContext);
                return object;
            }
            if (this.commandUrl != null) {
                Object object = this.engine.eval(new InputStreamReader(this.commandUrl.openStream()));
                return object;
            }
            return null;
        }
        finally {
            this.restoreVars(scriptContext, vars);
        }
    }

    public Object execute(ScriptContext scriptContext) throws ScriptException, IOException {
        return this.execute(scriptContext, null);
    }

    public Object execute(ScriptContext scriptContext, Map<String, Object> scriptObjects) throws ScriptException, IOException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            Object object = this.executeScript(scriptContext, scriptObjects);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public String toString() {
        if (this.compiledScript != null) {
            return this.compiledScript.toString();
        }
        return this.command;
    }
}

