/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.controller;

import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;

public class MouseTransformer
implements ChartMouseListener,
ChartMouseMoveListener {
    private boolean active;
    private int startX;
    private int startY;
    private final ChartRenderer chartArea;
    private final XAxis xAxis;
    private final YAxis yAxis;

    public MouseTransformer(ChartRenderer chartArea, XAxis xAxis, YAxis yAxis) {
        this.chartArea = chartArea;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        chartArea.addDisposeListener(new DisposeListener(){

            @Override
            public void onDispose() {
                MouseTransformer.this.dispose();
            }
        });
        chartArea.addMouseListener(this);
        chartArea.addMouseMoveListener(this);
    }

    public void dispose() {
        this.chartArea.removeMouseListener(this);
        this.chartArea.removeMouseMoveListener(this);
    }

    @Override
    public void onMouseDoubleClick(ChartMouseListener.MouseState state) {
    }

    @Override
    public void onMouseDown(ChartMouseListener.MouseState e) {
        if (e.button != 1 || e.state != SWT.MOD1) {
            return;
        }
        this.active = true;
        this.startX = e.x;
        this.startY = e.y;
    }

    @Override
    public void onMouseUp(ChartMouseListener.MouseState state) {
        this.active = false;
    }

    @Override
    public void onMouseMove(ChartMouseListener.MouseState state) {
        if (!this.active) {
            return;
        }
        int diffX = this.startX - state.x;
        this.startX = state.x;
        int diffY = this.startY - state.y;
        this.startY = state.y;
        Rectangle rect = this.chartArea.getClientAreaProxy().getClientRectangle();
        boolean update = false;
        if (rect.width > 0) {
            this.xAxis.transform((long)diffX, rect.width);
            update = true;
        }
        if (rect.height > 0) {
            this.yAxis.transform((double)diffY, rect.height);
            update = true;
        }
        if (update) {
            this.chartArea.redraw();
        }
    }
}

