/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.SeriesDataListener;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DataPoint;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSeriesRenderer
implements Renderer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSeriesRenderer.class);
    protected final SeriesData seriesData;
    private SeriesDataListener listener;
    private final ChartRenderer chartArea;
    private boolean visible = true;

    public AbstractDataSeriesRenderer(ChartRenderer chartArea, SeriesData seriesData) {
        this.chartArea = chartArea;
        this.seriesData = seriesData;
        this.listener = new SeriesDataListener(){

            public void dataUpdate(long startTimestamp, long endTimestamp) {
                AbstractDataSeriesRenderer.this.handleDataUpdate(startTimestamp, endTimestamp);
            }
        };
        seriesData.addListener(this.listener);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void handleDataUpdate(long startTimestamp, long endTimestamp) {
        logger.trace("Data update - {} -> {}", (Object)startTimestamp, (Object)endTimestamp);
        if (this.chartArea.isDisposed()) {
            return;
        }
        this.chartArea.refreshData();
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        if (!this.visible) {
            return;
        }
        this.performRender(g, clientRectangle);
    }

    protected abstract void performRender(Graphics var1, Rectangle var2);

    public void dispose() {
        this.seriesData.removeListener(this.listener);
    }

    @Override
    public Rectangle resize(Rectangle clientRectangle) {
        this.seriesData.setRequestWidth(clientRectangle.width);
        return null;
    }

    protected static boolean translateToPoint(Rectangle clientRect, XAxis x, YAxis y, DataPoint point, DataEntry entry) {
        point.x = (float)clientRect.x + x.translateToClient(clientRect.width, entry.getTimestamp());
        Double value = entry.getValue();
        if (value == null || Double.isNaN(value) || Double.isInfinite(value)) {
            return false;
        }
        point.y = (float)clientRect.y + y.translateToClient(clientRect.height, value.doubleValue());
        return true;
    }
}

