/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractRenderer
implements Renderer {
    private final Display display;
    private boolean disposed = false;
    private final ChartRenderer chart;

    public AbstractRenderer(ChartRenderer chart) {
        this.chart = chart;
        this.display = chart.getDisplay();
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.chart.removeRenderer(this);
        }
    }

    protected void redraw() {
        this.checkWidget();
        this.chart.redraw();
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            this.error(22);
        }
        if (this.disposed) {
            this.error(24);
        }
    }

    private void error(int code) {
        SWT.error((int)code);
    }
}

