/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.NavigableSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DataPoint;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractDataSeriesRenderer;
import org.eclipse.swt.graphics.Rectangle;

public class QualityRenderer
extends AbstractDataSeriesRenderer {
    public QualityRenderer(ChartRenderer chartArea, SeriesData abstractSeriesData) {
        super(chartArea, abstractSeriesData);
    }

    @Override
    protected void performRender(Graphics g, Rectangle clientRect) {
        XAxis xAxis = this.seriesData.getXAxis();
        YAxis yAxis = this.seriesData.getYAxis();
        g.setBackground(g.getSystemColor(3));
        g.setAlpha(128);
        NavigableSet entries = this.seriesData.getViewData().getEntries();
        if (entries.isEmpty()) {
            g.fillRectangle(clientRect);
            return;
        }
        g.setClipping(clientRect);
        DataPoint point = new DataPoint();
        Integer lastPosition = null;
        Integer lastValidPosition = null;
        DataEntry first = (DataEntry)entries.first();
        QualityRenderer.translateToPoint(clientRect, xAxis, yAxis, point, first);
        if (point.x > 0.0f) {
            g.fillRectangle(clientRect.x, clientRect.y, (int)point.x - clientRect.x, clientRect.height);
        }
        DataEntry last = (DataEntry)entries.last();
        QualityRenderer.translateToPoint(clientRect, xAxis, yAxis, point, last);
        if (point.x >= 0.0f && point.x < (float)clientRect.width) {
            g.fillRectangle((int)point.x, clientRect.y, (int)((float)clientRect.width - (point.x - 1.0f - (float)clientRect.x)), clientRect.height);
        } else if (point.x < 0.0f) {
            g.fillRectangle(clientRect);
        }
        for (DataEntry entry : entries) {
            boolean hasData = QualityRenderer.translateToPoint(clientRect, xAxis, yAxis, point, entry);
            boolean qualityOk = this.checkQuality(hasData, entry.getValue());
            if (lastPosition != null) {
                g.fillRectangle(lastPosition, clientRect.y, (int)point.x - lastPosition, clientRect.height);
            }
            if (!qualityOk) {
                if (lastValidPosition != null && lastPosition == null) {
                    g.fillRectangle(lastValidPosition, clientRect.y, (int)point.x - lastValidPosition, clientRect.height);
                }
                lastPosition = (int)point.x;
                continue;
            }
            lastValidPosition = (int)point.x;
            lastPosition = null;
        }
        g.setClipping(clientRect);
    }

    protected boolean checkQuality(boolean hasData, Double value) {
        return hasData;
    }
}

