/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.client.ngp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.client.ngp.ConnectionImpl;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueEntry;
import org.eclipse.scada.hd.data.ValueInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private final Executor executor;
    private final String itemId;
    private QueryParameters parameters;
    private QueryListener listener;
    private final ConnectionImpl connection;
    private boolean closed = false;
    private volatile Long queryId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryImpl(Executor executor, ConnectionImpl connection, Long queryId, String itemId, QueryParameters parameters, QueryListener listener) {
        this.executor = executor;
        this.connection = connection;
        this.queryId = queryId;
        this.itemId = itemId;
        this.parameters = parameters;
        this.listener = listener;
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            this.fireStateChange(listener, QueryState.REQUESTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Long queryId;
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            logger.info("Closing query: {} ({})", new Object[]{this.itemId, this.parameters});
            this.fireStateChange(this.listener, QueryState.DISCONNECTED);
            this.listener = null;
            queryId = this.queryId;
            this.queryId = null;
        }
        if (queryId != null) {
            this.connection.closeQuery(queryId);
        }
    }

    private void fireStateChange(final QueryListener listener, final QueryState state) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.updateState(state);
            }
        });
    }

    private void fireParameterChange(final QueryListener listener, final QueryParameters parameters, final Set<String> valueTypes) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.updateParameters(parameters, valueTypes);
            }
        });
    }

    private void fireDataChange(QueryListener listener, final int index, final Map<String, List<Double>> values, final List<ValueInformation> valueInformation) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.debug("Data update: {} (v: {}, vi: {})", new Object[]{index, values.size(), valueInformation.size()});
                QueryImpl.this.listener.updateData(index, values, valueInformation);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeParameters(final QueryParameters parameters) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            if (this.parameters == parameters) {
                return;
            }
            this.parameters = parameters;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    QueryImpl.this.connection.updateQueryParameters(QueryImpl.this, parameters);
                }
            });
        }
    }

    public Long getId() {
        return this.queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateStatus(QueryState state) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.fireStateChange(this.listener, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateData(int index, List<ValueEntry> values, List<ValueInformation> valueInformation) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            HashMap<String, List<Double>> valueMap = new HashMap<String, List<Double>>();
            for (ValueEntry entry : values) {
                valueMap.put(entry.getValueType(), entry.getValues());
            }
            this.fireDataChange(this.listener, index, valueMap, valueInformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateParameter(QueryParameters parameters, Set<String> valueTypes) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.fireParameterChange(this.listener, parameters, valueTypes);
        }
    }
}

