/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.net.base.data.Value;

public class ListValue
extends Value {
    private final List<Value> values;

    public ListValue() {
        this.values = new LinkedList<Value>();
    }

    public ListValue(int initialCapacity) {
        this.values = new ArrayList<Value>(initialCapacity);
    }

    public ListValue(List<Value> values) {
        this.values = values;
    }

    public ListValue(Value[] values) {
        this.values = new ArrayList<Value>(Arrays.asList(values));
    }

    public void add(Value value) {
        this.values.add(value);
    }

    public void remove(Value value) {
        this.values.remove(value);
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListValue other = (ListValue)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public List<Value> getValues() {
        return this.values;
    }
}

