/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base.data;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.net.base.data.DoubleValue;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;

public class ValueTools {
    public static Long toLong(Value value, Long defaultValue) {
        try {
            if (value instanceof IntegerValue) {
                return ((IntegerValue)value).getValue();
            }
            if (value instanceof LongValue) {
                return ((LongValue)value).getValue();
            }
            if (value instanceof DoubleValue) {
                return (long)((DoubleValue)value).getValue();
            }
            if (value instanceof StringValue) {
                String data = ((StringValue)value).getValue();
                return Long.decode(data);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long toLong(Value value, long defaultValue) {
        return ValueTools.toLong(value, defaultValue);
    }

    public static Integer toInteger(Value value, Integer defaultValue) {
        try {
            if (value instanceof IntegerValue) {
                return ((IntegerValue)value).getValue();
            }
            if (value instanceof LongValue) {
                return (int)((LongValue)value).getValue();
            }
            if (value instanceof DoubleValue) {
                return (int)((DoubleValue)value).getValue();
            }
            if (value instanceof StringValue) {
                String data = ((StringValue)value).getValue();
                return Integer.decode(data);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int toInteger(Value value, int defaultValue) {
        return ValueTools.toInteger(value, (Integer)defaultValue);
    }

    public static ListValue toStringList(Iterable<?> list) {
        ListValue listValue = new ListValue();
        for (Object obj : list) {
            listValue.add(new StringValue(obj.toString()));
        }
        return listValue;
    }

    public static List<String> fromStringList(ListValue list) {
        LinkedList<String> newList = new LinkedList<String>();
        for (Value value : list.getValues()) {
            newList.add(value.toString());
        }
        return newList;
    }
}

