/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.mina;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.eclipse.scada.net.base.data.BooleanValue;
import org.eclipse.scada.net.base.data.DoubleValue;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.net.mina.GMPPProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMPPProtocolDecoder
extends CumulativeProtocolDecoder
implements GMPPProtocol {
    private static final Logger logger = LoggerFactory.getLogger(GMPPProtocolDecoder.class);
    private final ThreadLocal<Charset> decoderLocal = new ThreadLocal<Charset>(){

        @Override
        protected Charset initialValue() {
            return Charset.forName("utf-8");
        }
    };
    private static final boolean disableIntern = Boolean.getBoolean("org.eclipse.scada.net.mina.GMPPProtocolDecoder.disableIntern");

    private String decodeStringFromStream(IoBuffer buffer, int size) {
        ByteBuffer data = buffer.buf().slice();
        data.limit(size);
        String result = this.decoderLocal.get().decode(data).toString();
        buffer.skip(size);
        if (disableIntern) {
            return result;
        }
        return result.intern();
    }

    private Value decodeValueFromStream(IoBuffer buffer) {
        int type = buffer.getInt();
        int len = buffer.getInt();
        logger.trace("Additional data: {} len: {}", (Object)type, (Object)len);
        switch (type) {
            case 2: {
                return LongValue.valueOf(buffer.getLong());
            }
            case 5: {
                return IntegerValue.valueOf(buffer.getInt());
            }
            case 1: {
                return new StringValue(this.decodeStringFromStream(buffer, len));
            }
            case 3: {
                return this.decodeDoubleValueFromStream(buffer);
            }
            case 8: {
                return BooleanValue.valueOf(buffer.get() != 0);
            }
            case 4: {
                return VoidValue.INSTANCE;
            }
            case 6: {
                return this.decodeListValueFromStream(buffer);
            }
            case 7: {
                return this.decodeMapValueFromStream(buffer);
            }
        }
        buffer.position(buffer.position() + len);
        return null;
    }

    private DoubleValue decodeDoubleValueFromStream(IoBuffer buffer) {
        double d = Double.longBitsToDouble(buffer.getLong());
        return new DoubleValue(d);
    }

    private ListValue decodeListValueFromStream(IoBuffer buffer) {
        int items = buffer.getInt();
        ArrayList<Value> values = new ArrayList<Value>(items);
        int i = 0;
        while (i < items) {
            values.add(this.decodeValueFromStream(buffer));
            ++i;
        }
        return new ListValue(values);
    }

    private MapValue decodeMapValueFromStream(IoBuffer buffer) {
        int items = buffer.getInt();
        HashMap<String, Value> values = new HashMap<String, Value>(items);
        int i = 0;
        while (i < items) {
            Value value = this.decodeValueFromStream(buffer);
            String key = this.decodeStringFromStream(buffer, buffer.getInt());
            values.put(key, value);
            ++i;
        }
        return new MapValue(values);
    }

    private Message decodeMessageFromStream(IoBuffer inputBuffer) {
        Message message = new Message();
        message.setCommandCode(inputBuffer.getInt());
        message.setTimestamp(inputBuffer.getLong());
        message.setSequence(inputBuffer.getLong());
        message.setReplySequence(inputBuffer.getLong());
        inputBuffer.getInt();
        Value value = this.decodeValueFromStream(inputBuffer);
        if (value instanceof MapValue) {
            message.setValues((MapValue)value);
        }
        return message;
    }

    protected boolean doDecode(IoSession session, IoBuffer inputBuffer, ProtocolDecoderOutput out) throws Exception {
        while (inputBuffer.remaining() >= 32) {
            int bodySize = inputBuffer.getInt(inputBuffer.position() + 4 + 8 + 8 + 8);
            if (inputBuffer.remaining() < 32 + bodySize) {
                return false;
            }
            Message message = this.decodeMessageFromStream(inputBuffer);
            if (message == null) continue;
            out.write((Object)message);
        }
        return false;
    }
}

