/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.mina;

import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.mina.MessageSender;
import org.eclipse.scada.net.mina.PrepareSendHandler;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoSessionSender
implements MessageSender {
    private static final long MAX_SEQUENCE = Integer.MAX_VALUE;
    private static final long INIT_SEQUENCE = 1L;
    private long sequence = 1L;
    private final IoSession session;
    public static Object STATS_QUEUED_BYTES = new Object();
    private final StatisticsImpl statistics;
    private static final Logger logger = LoggerFactory.getLogger(IoSessionSender.class);

    public IoSessionSender(IoSession session, StatisticsImpl statistics) {
        this.session = session;
        this.statistics = statistics;
        statistics.setLabel(STATS_QUEUED_BYTES, "Scheduled write bytes");
    }

    @Override
    public synchronized WriteFuture sendMessage(Message message, PrepareSendHandler handler) {
        message.setSequence(this.nextSequence());
        if (handler != null) {
            handler.prepareSend(message);
        }
        WriteFuture future = this.session.write((Object)message);
        logger.trace("Scheduled write bytes: {}", (Object)this.session.getScheduledWriteBytes());
        this.statistics.setCurrentValue(STATS_QUEUED_BYTES, (double)this.session.getScheduledWriteBytes());
        return future;
    }

    private long nextSequence() {
        long seq = this.sequence++;
        if (this.sequence >= Integer.MAX_VALUE) {
            this.sequence = 1L;
        }
        return seq;
    }

    @Override
    public void close() {
        this.session.close(true);
    }

    public String toString() {
        return this.session.toString();
    }
}

