/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

public enum SocketImpl {
    NIO{

        @Override
        public SocketAddress doLookup(String address, int port) {
            InetSocketAddress resolvedAddress = address == null ? new InetSocketAddress(port) : new InetSocketAddress(address, port);
            if (resolvedAddress.isUnresolved()) {
                throw new UnresolvedAddressException();
            }
            return resolvedAddress;
        }

        @Override
        public IoConnector createConnector() {
            return new NioSocketConnector();
        }

        @Override
        public IoAcceptor createAcceptor() {
            NioSocketAcceptor acceptor = new NioSocketAcceptor();
            acceptor.setReuseAddress(true);
            return acceptor;
        }
    }
    ,
    VMPIPE{

        @Override
        public SocketAddress doLookup(String address, int port) {
            return new VmPipeAddress(port);
        }

        @Override
        public IoConnector createConnector() {
            return new VmPipeConnector();
        }

        @Override
        public IoAcceptor createAcceptor() {
            return new VmPipeAcceptor();
        }
    };


    private SocketImpl() {
    }

    public static SocketImpl fromName(String name) {
        if (name == null) {
            return NIO;
        }
        try {
            SocketImpl impl = SocketImpl.valueOf(name);
            if (impl != null) {
                return impl;
            }
        }
        catch (Throwable throwable) {}
        if ("vm".equals(name)) {
            return VMPIPE;
        }
        if ("vmpipe".equals(name)) {
            return VMPIPE;
        }
        return NIO;
    }

    public abstract SocketAddress doLookup(String var1, int var2);

    public abstract IoConnector createConnector();

    public abstract IoAcceptor createAcceptor();

    /* synthetic */ SocketImpl(String string, int n, SocketImpl socketImpl) {
        this();
    }
}

