/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.export.excel.impl;

import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.eclipse.scada.ae.ui.views.export.excel.Cell;
import org.eclipse.scada.core.Variant;

public class ExcelCell
implements Cell {
    private final HSSFCell cell;
    private final HSSFCellStyle dateFormat;

    public ExcelCell(HSSFRow row, int column, HSSFCellStyle dateFormat) {
        this.cell = row.createCell(column);
        this.dateFormat = dateFormat;
    }

    public HSSFCell getCell() {
        return this.cell;
    }

    @Override
    public void setDataAsDate(Date date) {
        this.cell.setCellValue(date);
        this.cell.setCellStyle(this.dateFormat);
    }

    @Override
    public void setDataAsText(String text) {
        this.cell.setCellValue(text);
    }

    @Override
    public void setDataAsVariant(Variant variant) {
        if (variant == null) {
            return;
        }
        switch (variant.getType()) {
            case INT32: 
            case INT64: 
            case DOUBLE: {
                this.cell.setCellValue(variant.asDouble(Double.valueOf(0.0)).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.cell.setCellValue(variant.asBoolean());
                break;
            }
            case NULL: {
                break;
            }
            case STRING: 
            case UNKNOWN: {
                this.cell.setCellValue(variant.asString(""));
            }
        }
    }
}

