/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.connection.data;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.ui.connection.Activator;
import org.eclipse.scada.ca.ui.connection.data.ConfigurationInformationBean;
import org.eclipse.scada.ca.ui.data.FactoryEditorSourceInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.ui.utils.DisplayFutureListener;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Display;

public class FactoryInformationBean
extends AbstractPropertyChange
implements ConnectionStateListener,
IAdaptable {
    public static final String PROP_DATA = "factoryInformation";
    public static final String PROP_STATE = "state";
    private FactoryInformation factoryInformation;
    private final ConnectionService service;
    private final WritableSet configurations = new WritableSet();
    private State state = State.LAZY;

    public FactoryInformationBean(FactoryInformation factoryInformation, ConnectionService service) {
        this.service = service;
        this.setFactoryInformation(factoryInformation);
        service.getConnection().addConnectionStateListener((ConnectionStateListener)this);
    }

    public ConnectionService getService() {
        return this.service;
    }

    public void setState(State state) {
        State oldState = this.state;
        this.state = state;
        this.firePropertyChange(PROP_STATE, (Object)oldState, (Object)state);
    }

    public State getState() {
        return this.state;
    }

    public void loadConfiguration() {
        this.setState(State.LOADING);
        NotifyFuture task = this.service.getConnection().getFactoryWithData(this.factoryInformation.getId());
        task.addListener((FutureListener)new DisplayFutureListener(Display.getDefault(), (FutureListener)new FutureListener<FactoryInformation>(){

            public void complete(Future<FactoryInformation> future) {
                try {
                    FactoryInformationBean.this.setFactoryInformation(future.get());
                    FactoryInformationBean.this.setState(State.COMPLETE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    FactoryInformationBean.this.setError(e);
                }
                catch (ExecutionException e) {
                    FactoryInformationBean.this.setError(e);
                }
            }
        }));
    }

    protected void setError(Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.ca.ui.connection", "Failed to load factory", (Throwable)e));
        this.setFactoryInformation(null);
        this.setState(State.ERROR);
    }

    protected void setFactoryInformation(FactoryInformation factoryInformation) {
        this.configurations.clear();
        if (factoryInformation != null) {
            this.factoryInformation = factoryInformation;
            if (factoryInformation.getConfigurations() != null) {
                for (ConfigurationInformation cfg : factoryInformation.getConfigurations()) {
                    ConfigurationInformationBean cfgBean = new ConfigurationInformationBean(this.service, cfg);
                    this.configurations.add((Object)cfgBean);
                }
            }
        }
        this.firePropertyChange(PROP_DATA, null, factoryInformation);
    }

    public FactoryInformation getFactoryInformation() {
        return this.factoryInformation;
    }

    public WritableSet getConfigurations() {
        return this.configurations;
    }

    public void dispose() {
        this.service.getConnection().removeConnectionStateListener((ConnectionStateListener)this);
    }

    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        if (state != ConnectionState.BOUND) {
            this.configurations.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FactoryInformationBean.this.setFactoryInformation(null);
                    FactoryInformationBean.this.setState(State.LAZY);
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == FactoryEditorSourceInformation.class) {
            return new FactoryEditorSourceInformation(this.service, this.factoryInformation.getId());
        }
        return null;
    }

    public static enum State {
        LAZY,
        LOADING,
        COMPLETE,
        ERROR;

    }
}

