/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator.page;

import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.ui.client.signalgenerator.SimulationTarget;
import org.eclipse.swt.widgets.Display;

public class BooleanGenerator {
    private Display display;
    private int startDelay = 1000;
    private int endDelay = 1000;
    private int iterations = -1;
    private boolean running = false;
    private long lastTick = 0L;
    private State currentState;
    private final SimulationTarget target;

    public BooleanGenerator(Display display, SimulationTarget target) {
        this.display = display;
        this.target = target;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.lastTick = System.currentTimeMillis();
        this.currentState = State.START_DELAY;
        this.running = true;
        this.triggerRun();
    }

    private void triggerRun() {
        this.display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                if (BooleanGenerator.this.running) {
                    BooleanGenerator.this.tick();
                    BooleanGenerator.this.triggerRun();
                }
            }
        });
    }

    public void stop() {
        if (!this.running) {
            this.running = false;
            return;
        }
    }

    public void dispose() {
        this.stop();
        this.display = null;
    }

    protected void tick() {
        long now = System.currentTimeMillis();
        switch (this.currentState) {
            case START_DELAY: {
                if (now - this.lastTick <= (long)this.startDelay) break;
                this.currentState = State.END_DELAY;
                this.lastTick = now;
                this.target.writeValue(Variant.TRUE);
                break;
            }
            case END_DELAY: {
                if (now - this.lastTick <= (long)this.endDelay) break;
                this.currentState = State.START_DELAY;
                this.lastTick = now;
                if (this.iterations > 0) {
                    --this.iterations;
                }
                this.target.writeValue(Variant.FALSE);
            }
        }
        if (this.iterations == 0) {
            this.running = false;
        }
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public int getEndDelay() {
        return this.endDelay;
    }

    public void setEndDelay(int endDelay) {
        this.endDelay = endDelay;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public static enum State {
        START_DELAY,
        END_DELAY;

    }
}

