/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.data.Operation;
import org.eclipse.scada.ca.ui.util.ConfigurationHelper;
import org.eclipse.scada.ca.ui.util.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffController {
    private static final Logger logger = LoggerFactory.getLogger(DiffController.class);
    private Map<String, Map<String, Map<String, String>>> localData;
    private Set<String> ignoreFactories = new HashSet<String>();
    private Map<String, Set<String>> ignoreFields = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Map<String, String>>> remoteData = Collections.emptyMap();

    public void setLocalData(Map<String, Map<String, Map<String, String>>> localData) {
        this.localData = localData;
    }

    public Set<String> getIgnoreFactories() {
        return this.ignoreFactories;
    }

    public Map<String, Set<String>> getIgnoreFields() {
        return this.ignoreFields;
    }

    public long setRemoteData(Collection<FactoryInformation> remoteData) {
        HashMap<String, Map<String, Map<String, String>>> data = new HashMap<String, Map<String, Map<String, String>>>();
        long count = ConfigurationHelper.convert(remoteData, data);
        this.setRemoteData(data);
        return count;
    }

    public void setRemoteData(Map<String, Map<String, Map<String, String>>> data) {
        this.remoteData = data;
    }

    public List<DiffEntry> merge(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DiffController_TaskName, this.localData.size() + this.remoteData.size());
            List<DiffEntry> list = this.processMerge(monitor);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private List<DiffEntry> processMerge(IProgressMonitor monitor) {
        LinkedList<DiffEntry> result = new LinkedList<DiffEntry>();
        for (Map.Entry<String, Map<String, Map<String, String>>> factoryEntry : this.localData.entrySet()) {
            if (this.ignoreFactories.contains(factoryEntry.getKey())) continue;
            if (!this.remoteData.containsKey(factoryEntry.getKey())) {
                this.addAll(factoryEntry.getKey(), result, factoryEntry.getValue());
            } else {
                Map<String, Map<String, String>> remoteFactory = this.remoteData.get(factoryEntry.getKey());
                for (Map.Entry<String, Map<String, String>> cfgEntry : factoryEntry.getValue().entrySet()) {
                    if (!remoteFactory.containsKey(cfgEntry.getKey())) {
                        result.add(new DiffEntry(factoryEntry.getKey(), cfgEntry.getKey(), Operation.ADD, null, cfgEntry.getValue(), null));
                        continue;
                    }
                    Map<String, String> remoteData = remoteFactory.get(cfgEntry.getKey());
                    if (this.isEqual(cfgEntry.getValue(), remoteData)) continue;
                    logger.debug("Detected update");
                    logger.debug("From: {}", remoteData);
                    logger.debug("To: {}", cfgEntry.getValue());
                    DiffEntry diffEntry = this.makeDiffEntry(factoryEntry.getKey(), cfgEntry.getKey(), remoteData, cfgEntry.getValue());
                    if (diffEntry == null) continue;
                    result.add(diffEntry);
                }
            }
            monitor.worked(1);
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> factoryEntry : this.remoteData.entrySet()) {
            if (this.ignoreFactories.contains(factoryEntry.getKey())) continue;
            if (!this.localData.containsKey(factoryEntry.getKey())) {
                this.removeAll(factoryEntry.getKey(), result, factoryEntry.getValue());
            } else {
                Map<String, Map<String, String>> localFactory = this.localData.get(factoryEntry.getKey());
                for (Map.Entry<String, Map<String, String>> cfgEntry : factoryEntry.getValue().entrySet()) {
                    if (localFactory.containsKey(cfgEntry.getKey())) continue;
                    result.add(new DiffEntry(factoryEntry.getKey(), cfgEntry.getKey(), Operation.DELETE, null, cfgEntry.getValue(), null));
                }
            }
            monitor.worked(1);
        }
        return result;
    }

    private DiffEntry makeDiffEntry(String factoryId, String configurationId, Map<String, String> remoteData, Map<String, String> localData) {
        Set<String> ignoreFields;
        Set<String> set = ignoreFields = this.ignoreFields != null ? this.ignoreFields.get(factoryId) : null;
        if (ignoreFields == null || ignoreFields.isEmpty()) {
            return new DiffEntry(factoryId, configurationId, Operation.UPDATE_SET, remoteData, localData, null);
        }
        HashMap<String, String> addedOrUpdatedData = new HashMap<String, String>();
        HashSet<String> removedData = new HashSet<String>();
        HashMap<String, String> oldData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : localData.entrySet()) {
            if (ignoreFields.contains(entry.getKey())) continue;
            if (entry.getValue() != null && remoteData.containsKey(entry.getKey())) {
                if (entry.getValue().equals(remoteData.get(entry.getKey()))) continue;
                oldData.put(entry.getKey(), remoteData.get(entry.getKey()));
                addedOrUpdatedData.put(entry.getKey(), entry.getValue());
                continue;
            }
            oldData.put(entry.getKey(), null);
            addedOrUpdatedData.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : remoteData.entrySet()) {
            String key = entry.getKey();
            if (localData.containsKey(key) || ignoreFields.contains(key)) continue;
            oldData.put(key, entry.getValue());
            removedData.add(key);
        }
        if (addedOrUpdatedData.isEmpty() && removedData.isEmpty()) {
            return null;
        }
        return new DiffEntry(factoryId, configurationId, Operation.UPDATE_DIFF, oldData, addedOrUpdatedData, removedData);
    }

    private boolean isEqual(Map<String, String> localData, Map<String, String> remoteData) {
        return remoteData.equals(localData);
    }

    private void addAll(String factoryId, Collection<DiffEntry> result, Map<String, Map<String, String>> value) {
        for (Map.Entry<String, Map<String, String>> cfgEntry : value.entrySet()) {
            result.add(new DiffEntry(factoryId, cfgEntry.getKey(), Operation.ADD, null, cfgEntry.getValue(), null));
        }
    }

    private void removeAll(String factoryId, Collection<DiffEntry> result, Map<String, Map<String, String>> value) {
        for (Map.Entry<String, Map<String, String>> cfgEntry : value.entrySet()) {
            result.add(new DiffEntry(factoryId, cfgEntry.getKey(), Operation.DELETE, null, cfgEntry.getValue(), null));
        }
    }

    public void addIgnoreFactory(String factoryId) {
        this.ignoreFactories.add(factoryId);
    }

    public void setIgnoreFactories(Set<String> factories) {
        this.ignoreFactories = new HashSet<String>(factories);
    }

    public void addIgnoreEntry(String factoryId, String fieldName) {
        Set<String> fields = this.ignoreFields.get(factoryId);
        if (fields == null) {
            fields = new HashSet<String>();
            this.ignoreFields.put(factoryId, fields);
        }
        fields.add(fieldName);
    }

    public void setIgnoreFields(Map<String, Set<String>> ignoreFields) {
        this.ignoreFields = ignoreFields != null ? new HashMap<String, Set<String>>(ignoreFields) : null;
    }

    public Map<String, Map<String, Map<String, String>>> getLocalData() {
        return this.localData;
    }

    public Map<String, Map<String, Map<String, String>>> getRemoteData() {
        return this.remoteData;
    }

    public Set<String> makeKnownFactories() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.localData.keySet());
        result.addAll(this.remoteData.keySet());
        return result;
    }
}

