/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.console;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.client.test.Activator;
import org.eclipse.scada.da.ui.client.test.console.CommandContext;
import org.eclipse.scada.da.ui.client.test.console.CommandHandler;
import org.eclipse.scada.da.ui.client.test.console.CommandProcessorImpl;
import org.eclipse.scada.da.ui.client.test.console.ItemTrace;
import org.eclipse.scada.da.ui.client.test.console.ItemTraceIOConsole;
import org.eclipse.scada.da.ui.connection.data.AbstractItemHolder;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemListenerHolder;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.FrameworkUtil;

public class DataItemConsole {
    private final Item item;
    private final IOConsole console;
    private final IConsoleListener consoleListener = new IConsoleListener(){

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == DataItemConsole.this.console) {
                    DataItemConsole.this.dispose();
                }
                ++n2;
            }
        }

        public void consolesAdded(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == DataItemConsole.this.console) {
                    DataItemConsole.this.init();
                }
                ++n2;
            }
        }
    };
    private boolean running;
    private AbstractItemHolder holder;
    private final ItemUpdateListener itemListener = new ItemUpdateListener(){

        public void notifySubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
            DataItemConsole.this.processSubscriptionChange(subscriptionState, subscriptionError);
        }

        public void notifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
            DataItemConsole.this.processDataChange(value, attributes, cache);
        }
    };
    private final ItemListenerHolder.HolderListener holderListener = new ItemListenerHolder.HolderListener(){

        public void connectionStateChange(Connection connection, ConnectionState state, Throwable error) {
            DataItemConsole.this.processConnectionStateChange(connection, state, error);
        }

        public void connectionChange(ConnectionService connection) {
            DataItemConsole.this.processConnectionChange(connection);
        }
    };
    private IOConsoleOutputStream connectionStream;
    private IOConsoleOutputStream dataStream;
    private PrintStream connectionPrintStream;
    private PrintStream dataPrintStream;
    private CommandProcessorImpl processor;
    private final ItemTrace trace = new ItemTrace(){

        @Override
        public void stop() {
            DataItemConsole.this.stop();
        }
    };
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public DataItemConsole(Item item) {
        this.item = item;
        this.console = new ItemTraceIOConsole(this.trace, item.toLabel(), "org.eclipse.scada.da.item.trace", Activator.getImageDescriptor("icons/16x16/item_trace.gif"), "UTF-8", true);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this.consoleListener);
        this.running = true;
    }

    public IConsole getConsole() {
        return this.console;
    }

    protected void message(PrintStream stream, String format, Object ... args) {
        this.message(new Date(), stream, format, args);
    }

    protected void message(Date date, PrintStream stream, String format, Object ... args) {
        if (stream == null) {
            return;
        }
        stream.print(String.valueOf(DF.format(date)) + ": ");
        stream.printf(format, args);
        stream.println();
        stream.flush();
    }

    protected void processConnectionChange(ConnectionService connection) {
        this.message(this.connectionPrintStream, "Connection - %s", connection);
    }

    protected void processConnectionStateChange(Connection connection, ConnectionState state, Throwable error) {
        this.message(this.connectionPrintStream, "Connection state - state: %s", state);
        if (error != null) {
            error.printStackTrace(this.connectionPrintStream);
        }
    }

    protected void processDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
        Date now = new Date();
        this.message(now, this.dataPrintStream, "Value change - value: %s, cache: %s, attributes: %s", value, cache, attributes);
        if (attributes != null) {
            for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
                this.message(now, this.dataPrintStream, "\t%s -> %s", entry.getKey(), entry.getValue());
            }
        }
    }

    protected void processSubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
        this.message(this.dataPrintStream, "Subscription state - %s", subscriptionState);
        if (subscriptionError != null) {
            subscriptionError.printStackTrace(this.dataPrintStream);
        }
    }

    protected void init() {
        this.connectionStream = this.console.newOutputStream();
        this.connectionPrintStream = new PrintStream((OutputStream)this.connectionStream);
        this.dataStream = this.console.newOutputStream();
        this.dataPrintStream = new PrintStream((OutputStream)this.dataStream);
        this.processor = new CommandProcessorImpl(this.item.toLabel(), (InputStream)this.console.getInputStream(), (OutputStream)this.console.newOutputStream(), (OutputStream)this.console.newOutputStream());
        this.holder = new ItemListenerHolder(FrameworkUtil.getBundle(DataItemConsole.class).getBundleContext(), this.item, this.itemListener, this.holderListener);
        this.createCommands();
    }

    private void createCommands() {
        CommandHandler closeCommand = new CommandHandler(){

            @Override
            public void runCommand(CommandContext context) throws Exception {
                DataItemConsole.this.removeConsole();
            }
        };
        this.processor.addCommand("close", closeCommand);
        this.processor.addCommand("exit", closeCommand);
        this.processor.addCommand("stop", new CommandHandler(){

            @Override
            public void runCommand(CommandContext context) throws Exception {
                DataItemConsole.this.stop();
            }
        });
    }

    protected void removeConsole() {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
    }

    protected void dispose() {
        this.stop();
        if (this.processor != null) {
            this.processor.dispose();
            this.processor = null;
        }
        if (this.connectionPrintStream != null) {
            this.connectionPrintStream.close();
            this.connectionStream = null;
            this.connectionPrintStream = null;
        }
        if (this.dataPrintStream != null) {
            this.dataPrintStream.close();
            this.dataStream = null;
            this.dataPrintStream = null;
        }
        if (this.running) {
            this.running = false;
            ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this.consoleListener);
        }
    }

    protected synchronized void stop() {
        if (this.holder != null) {
            this.holder.dispose();
            this.holder = null;
        }
    }
}

