/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.StepRenderer;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.QueryInput;
import org.eclipse.scada.ui.chart.viewer.input.QuerySeriesData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveInput
extends QueryInput {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveInput.class);
    private boolean disposed;
    private final ChartViewer viewer;
    private final StepRenderer renderer;
    private final QuerySeriesData data;

    public ArchiveInput(Item item, ChartViewer viewer, QuerySeriesData querySeriesData, ResourceManager resourceManager) {
        super(resourceManager);
        this.viewer = viewer;
        this.data = querySeriesData;
        this.renderer = new StepRenderer(this.viewer.getChartRenderer(), (SeriesData)querySeriesData);
        viewer.getChartRenderer().addRenderer((Renderer)this.renderer);
        this.attachHover(viewer, querySeriesData.getXAxis());
        this.setQuery(querySeriesData.getQuery(), "AVG");
    }

    public QuerySeriesData getData() {
        return this.data;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        logger.debug("Setting channel visibility - name: {}#{}, visiblity: {}", new Object[]{this.data, this.getChannelName(), visible});
        if (visible) {
            this.data.open();
        } else {
            this.data.close();
        }
    }

    @Override
    public void setSelection(boolean state) {
    }

    @Override
    protected AbstractLineRender getLineRenderer() {
        return this.renderer;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.viewer.removeInput(this);
        this.viewer.getChartRenderer().removeRenderer((Renderer)this.renderer);
        this.renderer.dispose();
        if (this.data != null) {
            this.data.dispose();
        }
        super.dispose();
    }

    @Override
    public void tick(long now) {
    }
}

