/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.styles.DataItemValueStateExtractor;
import org.eclipse.scada.da.ui.widgets.Activator;
import org.eclipse.scada.da.ui.widgets.realtime.AttributePair;
import org.eclipse.scada.da.ui.widgets.realtime.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEntry
extends Observable
implements IAdaptable,
IPropertySource,
DataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(ListEntry.class);
    private DataItemHolder dataItem;
    private Item item;
    private DataItemValue value;
    private final StateStyler styler;
    private final StyleBlinker blinker;
    private StyleBlinker.CurrentStyle currentStyle = StyleBlinker.CurrentStyle.EMPTY;

    public ListEntry() {
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                ListEntry.this.handleStyleUpdate(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
    }

    public Item getItem() {
        return this.item;
    }

    public DataItemHolder getDataItem() {
        return this.dataItem;
    }

    public synchronized void setDataItem(Item item) {
        this.clear();
        this.item = item;
        this.dataItem = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, (DataSourceListener)this);
    }

    public void dispose() {
        this.styler.dispose();
        this.blinker.dispose();
        this.clear();
    }

    public synchronized void clear() {
        this.item = null;
        if (this.dataItem != null) {
            this.dataItem.dispose();
        }
    }

    public DataItemValue getItemValue() {
        DataItemValue value = this.value;
        if (value != null) {
            return value;
        }
        return DataItemValue.DISCONNECTED;
    }

    public Variant getValue() {
        if (this.value == null) {
            return Variant.NULL;
        }
        return this.value.getValue();
    }

    public SubscriptionState getSubscriptionState() {
        if (this.value == null) {
            return SubscriptionState.DISCONNECTED;
        }
        return this.value.getSubscriptionState();
    }

    public synchronized List<AttributePair> getAttributes() {
        if (this.value == null) {
            return new LinkedList<AttributePair>();
        }
        ArrayList<AttributePair> pairs = new ArrayList<AttributePair>(this.value.getAttributes().size());
        for (Map.Entry entry : this.value.getAttributes().entrySet()) {
            pairs.add(new AttributePair(this.item, (String)entry.getKey(), (Variant)entry.getValue()));
        }
        return pairs;
    }

    public synchronized boolean hasAttributes() {
        if (this.value == null) {
            return false;
        }
        return !this.value.getAttributes().isEmpty();
    }

    public Throwable getSubscriptionError() {
        if (this.value == null) {
            return null;
        }
        return this.value.getSubscriptionError();
    }

    public void updateData(DataItemValue value) {
        this.value = value;
        this.styler.style((StateInformation)new DataItemValueStateExtractor(value));
        this.setChanged();
        this.notifyObservers(value);
    }

    protected void handleStyleUpdate(StyleBlinker.CurrentStyle style) {
        this.currentStyle = style;
        this.setChanged();
        this.notifyObservers(this.value);
    }

    public Image getImage() {
        return this.currentStyle.image;
    }

    public Color getBackground() {
        return this.currentStyle.background;
    }

    public Color getForeground() {
        return this.currentStyle.foreground;
    }

    public Font getFont() {
        return this.currentStyle.font;
    }

    public Object getAdapter(Class adapter) {
        logger.trace("Request adapter to : {}", (Object)adapter);
        if (adapter == Item.class && this.item != null) {
            return new Item(this.item);
        }
        return null;
    }

    public Object getEditableValue() {
        return this.item.getId();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        LinkedList<PropertyDescriptor> result = new LinkedList<PropertyDescriptor>();
        PropertyDescriptor pd = new PropertyDescriptor((Object)Properties.ITEM_ID, Messages.ListEntry_Property_Name_Id);
        pd.setCategory(Messages.ListEntry_Property_Category_Id);
        pd.setAlwaysIncompatible(true);
        result.add(pd);
        pd = new PropertyDescriptor((Object)Properties.CONNECTION_URI, Messages.ListEntry_Property_Name_Connection);
        pd.setCategory(Messages.ListEntry_Property_Category_Connection);
        pd.setAlwaysIncompatible(true);
        result.add(pd);
        pd = new PropertyDescriptor((Object)Properties.VALUE, Messages.ListEntry_Property_Name_Value);
        pd.setCategory(Messages.ListEntry_Property_Category_Value);
        pd.setAlwaysIncompatible(true);
        result.add(pd);
        pd = new PropertyDescriptor((Object)Properties.SUBSCRIPTION_STATE, Messages.ListEntry_Property_Name_Subscription);
        pd.setCategory(Messages.ListEntry_Property_Category_State);
        pd.setAlwaysIncompatible(true);
        result.add(pd);
        return result.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Properties) {
            switch ((Properties)((Object)id)) {
                case ITEM_ID: {
                    return this.item.getId();
                }
                case CONNECTION_URI: {
                    return this.item.getConnectionString();
                }
                case VALUE: {
                    return this.value;
                }
                case SUBSCRIPTION_STATE: {
                    if (this.value == null) {
                        return SubscriptionState.DISCONNECTED;
                    }
                    return this.value.getSubscriptionState();
                }
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static enum Properties {
        ITEM_ID,
        CONNECTION_URI,
        VALUE,
        SUBSCRIPTION_STATE;

    }
}

