/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.jobs;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class LoadFactoryJob
extends Job {
    private final ConnectionService service;
    private final String factoryId;
    private FactoryInformation factory;
    private final AtomicReference<NotifyFuture<FactoryInformation>> task = new AtomicReference();

    public LoadFactoryJob(ConnectionService service, String factoryId) {
        super("Loading data");
        this.setUser(true);
        this.service = service;
        this.factoryId = factoryId;
    }

    public FactoryInformation getFactory() {
        return this.factory;
    }

    protected void canceling() {
        NotifyFuture task = this.task.getAndSet(null);
        if (task != null) {
            task.cancel(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                NotifyFuture task = this.service.getConnection().getFactoryWithData(this.factoryId);
                this.task.set((NotifyFuture<FactoryInformation>)task);
                this.factory = (FactoryInformation)task.get();
            }
            catch (InterruptedException interruptedException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                this.task.set(null);
                monitor.done();
                return iStatus;
            }
            catch (ExecutionException e) {
                Status status = new Status(4, "org.eclipse.scada.ca.ui", "Failed to load data", (Throwable)e);
                this.task.set(null);
                monitor.done();
                return status;
            }
        }
        finally {
            this.task.set(null);
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

