/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.selector;

import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scada.ui.chart.selector.Messages;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ChartInputSelector {
    private final CheckboxTableViewer viewer;
    private final IObservableList inputs;
    private final IViewerObservableSet checked;
    private final ObservableListContentProvider contentProvider;
    private final IObservableMap visibleElements;

    public ChartInputSelector(Composite parent, ChartViewer chart) {
        this(parent, chart, false);
    }

    public ChartInputSelector(Composite parent, ChartViewer chart, boolean showHeader) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)65536);
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartInputSelector.this.handleDispose();
            }
        });
        this.inputs = chart.getItems();
        if (showHeader) {
            TableLayout layout = new TableLayout();
            TableViewerColumn col = new TableViewerColumn((TableViewer)this.viewer, 0);
            col.getColumn().setText(Messages.ChartInputSelector_Channels_Label);
            this.viewer.getTable().setHeaderVisible(true);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
            this.viewer.getTable().setLayout((Layout)layout);
        }
        this.contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProviderExtension(Properties.observeEach((IObservableSet)this.contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{BeanProperties.value((String)"label"), BeanProperties.value((String)"preview")})));
        this.viewer.setInput((Object)this.inputs);
        this.visibleElements = BeanProperties.value(ChartInput.class, (String)"visible").observeDetail(this.contentProvider.getKnownElements());
        this.checked = ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.viewer, null);
        for (Object key : this.visibleElements.keySet()) {
            this.checkEntry(key);
        }
        this.visibleElements.addMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                for (Object key : event.diff.getAddedKeys()) {
                    ChartInputSelector.this.checkEntry(key);
                }
                for (Object key : event.diff.getChangedKeys()) {
                    ChartInputSelector.this.checkEntry(key);
                }
            }
        });
        this.checked.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getRemovals()) {
                    ((ChartInput)o).setVisible(false);
                }
                for (Object o : event.diff.getAdditions()) {
                    ((ChartInput)o).setVisible(true);
                }
            }
        });
    }

    private void checkEntry(Object key) {
        if (((ChartInput)key).isVisible()) {
            this.checked.add(key);
        } else {
            this.checked.remove(key);
        }
    }

    protected void handleDispose() {
        this.visibleElements.dispose();
        this.contentProvider.dispose();
        this.checked.dispose();
        this.inputs.dispose();
    }

    public void dispose() {
        this.viewer.getControl().dispose();
    }

    private final class ObservableMapLabelProviderExtension
    extends ObservableMapLabelProvider {
        private ObservableMapLabelProviderExtension(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return super.getColumnImage(element, columnIndex);
            }
            if (!(element instanceof ChartInput)) {
                return super.getColumnImage(element, columnIndex);
            }
            return ((ChartInput)element).getPreview(30, 15);
        }
    }
}

